/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import com.google.common.collect.Range;
import java.util.Collection;
import java.util.function.BiPredicate;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.AreaFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class AreaFilter
implements IPeakFilter<AreaFilterSettings> {
    private static BiPredicate<Double, Double> AREA_LESS_THAN_MINIMUM_COMPARATOR = (peakArea, areaSetting) -> peakArea < areaSetting;
    private static BiPredicate<Double, Double> AREA_GREATER_THAN_MAXIMUM_COMPARATOR = (peakArea, areaSetting) -> peakArea > areaSetting;
    private static BiPredicate<Double, Range<Double>> AREA_NOT_WITHIN_RANGE = (peakArea, areaSetting) -> !areaSetting.contains((Comparable)peakArea);

    public String getName() {
        return "Area Filter";
    }

    public String getDescription() {
        return "Filter peaks by peak area values";
    }

    public Class<AreaFilterSettings> getConfigClass() {
        return AreaFilterSettings.class;
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, AreaFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (AreaFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        AreaPredicate<?> predicate = AreaFilter.getPredicate(configuration);
        for (IPeak peak : read) {
            AreaFilter.processPeak(listener, configuration, peak, predicate);
            subMonitor.worked(1);
        }
    }

    private static AreaPredicate<?> getPredicate(AreaFilterSettings configuration) {
        switch (configuration.getFilterSelectionCriterion()) {
            case AREA_LESS_THAN_MINIMUM: {
                return new AreaPredicate<Double>(AREA_LESS_THAN_MINIMUM_COMPARATOR, configuration.getMinimumAreaValue());
            }
            case AREA_GREATER_THAN_MAXIMUM: {
                return new AreaPredicate<Double>(AREA_GREATER_THAN_MAXIMUM_COMPARATOR, configuration.getMaximumAreaValue());
            }
            case AREA_NOT_WITHIN_RANGE: {
                return new AreaPredicate<Range>(AREA_NOT_WITHIN_RANGE, Range.closed((Comparable)Double.valueOf(configuration.getMinimumAreaValue()), (Comparable)Double.valueOf(configuration.getMaximumAreaValue())));
            }
        }
        throw new IllegalArgumentException("Unsupported Peak Filter Selection Criterion!");
    }

    private static <X extends IPeak> void processPeak(CRUDListener<X, IPeakModel> listener, AreaFilterSettings configuration, X peak, AreaPredicate<?> predicate) {
        switch (configuration.getFilterTreatmentOption()) {
            case ENABLE_PEAK: {
                if (!predicate.test(peak.getIntegratedArea())) break;
                peak.setActiveForAnalysis(true);
                listener.updated(peak);
                break;
            }
            case DEACTIVATE_PEAK: {
                if (!predicate.test(peak.getIntegratedArea())) break;
                peak.setActiveForAnalysis(false);
                listener.updated(peak);
                break;
            }
            case KEEP_PEAK: {
                if (!predicate.negate().test(peak.getIntegratedArea())) break;
                listener.delete(peak);
                break;
            }
            case DELETE_PEAK: {
                if (!predicate.test(peak.getIntegratedArea())) break;
                listener.delete(peak);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Peak Filter Treatment Option!");
            }
        }
    }

    private static class AreaPredicate<T> {
        private final BiPredicate<Double, T> predicate;
        private final T areaSetting;

        public AreaPredicate(BiPredicate<Double, T> predicate, T areaSetting) {
            this.predicate = predicate;
            this.areaSetting = areaSetting;
        }

        public AreaPredicate<?> negate() {
            return new AreaPredicate<T>(this.predicate.negate(), this.areaSetting);
        }

        public boolean test(double integratedArea) {
            boolean result = this.predicate.test(integratedArea, (Double)this.areaSetting);
            return result;
        }
    }
}

