/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.support.settings.DoubleSettingsProperty;
import org.eclipse.chemclipse.support.settings.EnumSelectionSettingProperty;
import org.eclipse.chemclipse.xxd.model.support.AreaSelection;
import org.eclipse.chemclipse.xxd.model.support.TreatmentOption;

public class AreaPercentFilterSettings {
    @JsonProperty(value="Minimum area:")
    @JsonPropertyDescription(value="The minimum percentage area value of a peak to be filtered accordingly.")
    @DoubleSettingsProperty(minValue=0.0, maxValue=100.0)
    private double minimumPercentageAreaValue = 1.0;
    @JsonProperty(value="Maximum area:")
    @JsonPropertyDescription(value="The maximum percentage area value of a peak to be filtered accordingly.")
    @DoubleSettingsProperty(minValue=0.0, maxValue=100.0)
    private double maximumPercentageAreaValue = 10.0;
    @JsonProperty(value="Peak Treatment Option:")
    @EnumSelectionSettingProperty
    private TreatmentOption filterTreatmentOption = TreatmentOption.DEACTIVATE_PEAK;
    @JsonProperty(value="Peak Selection Criterion:")
    @EnumSelectionSettingProperty
    private AreaSelection filterSelectionCriterion = AreaSelection.AREA_LESS_THAN_MINIMUM;

    public double getMinimumPercentageAreaValue() {
        return this.minimumPercentageAreaValue;
    }

    public void setMinimumPercentageAreaValue(double minimumPercentageAreaValue) {
        this.minimumPercentageAreaValue = minimumPercentageAreaValue;
    }

    public double getMaximumPercentageAreaValue() {
        return this.maximumPercentageAreaValue;
    }

    public void setMaximumPercentageAreaValue(double maximumPercentageAreaValue) {
        this.maximumPercentageAreaValue = maximumPercentageAreaValue;
    }

    public TreatmentOption getFilterTreatmentOption() {
        return this.filterTreatmentOption;
    }

    public void setFilterTreatmentOption(TreatmentOption filterTreatmentOption) {
        this.filterTreatmentOption = filterTreatmentOption;
    }

    public AreaSelection getFilterSelectionCriterion() {
        return this.filterSelectionCriterion;
    }

    public void setFilterSelectionCriterion(AreaSelection filterSelectionCriterion) {
        this.filterSelectionCriterion = filterSelectionCriterion;
    }
}

