/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import java.util.function.BiPredicate;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.AsymmetryFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class AsymmetryFilter
implements IPeakFilter<AsymmetryFilterSettings> {
    private static BiPredicate<Double, Double> ASYMMETRY_FACTOR_SMALLER_THAN_LIMIT_COMPARATOR = (factor, factorSetting) -> factor < factorSetting;
    private static BiPredicate<Double, Double> ASYMMETRY_FACTOR_GREATER_THAN_LIMIT_COMPARATOR = (factor, factorSetting) -> factor > factorSetting;

    public String getName() {
        return "Asymmetry Filter";
    }

    public String getDescription() {
        return "Filter peaks by peak asymmetry factor (As)";
    }

    public Class<AsymmetryFilterSettings> getConfigClass() {
        return AsymmetryFilterSettings.class;
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, AsymmetryFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (AsymmetryFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        FactorPredicate<?> predicate = AsymmetryFilter.getPredicate(configuration);
        for (IPeak peak : read) {
            AsymmetryFilter.processPeak(configuration, listener, peak, predicate);
            subMonitor.worked(1);
        }
    }

    private static FactorPredicate<?> getPredicate(AsymmetryFilterSettings configuration) {
        switch (configuration.getFilterSelectionCriterion()) {
            case ASYMMETRY_FACTOR_SMALLER_THAN_LIMIT: {
                return new FactorPredicate<Double>(ASYMMETRY_FACTOR_SMALLER_THAN_LIMIT_COMPARATOR, configuration.getPeakAsymmetryFactor());
            }
            case ASYMMETRY_FACTOR_GREATER_THAN_LIMIT: {
                return new FactorPredicate<Double>(ASYMMETRY_FACTOR_GREATER_THAN_LIMIT_COMPARATOR, configuration.getPeakAsymmetryFactor());
            }
        }
        throw new IllegalArgumentException("Unsupported Peak Filter Selection Criterion!");
    }

    private static <X extends IPeak> void processPeak(AsymmetryFilterSettings configuration, CRUDListener<X, IPeakModel> listener, X peak, FactorPredicate<?> predicate) {
        double peakAsymmetryFactor = peak.getPeakModel().getTailing() / peak.getPeakModel().getLeading();
        switch (configuration.getFilterTreatmentOption()) {
            case ENABLE_PEAK: {
                if (!predicate.test(peakAsymmetryFactor)) break;
                peak.setActiveForAnalysis(true);
                listener.updated(peak);
                break;
            }
            case DEACTIVATE_PEAK: {
                if (!predicate.test(peakAsymmetryFactor)) break;
                peak.setActiveForAnalysis(false);
                listener.updated(peak);
                break;
            }
            case KEEP_PEAK: {
                if (!predicate.negate().test(peakAsymmetryFactor)) break;
                listener.delete(peak);
                break;
            }
            case DELETE_PEAK: {
                if (!predicate.test(peakAsymmetryFactor)) break;
                listener.delete(peak);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Peak Filter Treatment Option!");
            }
        }
    }

    private static class FactorPredicate<T> {
        private final BiPredicate<Double, T> predicate;
        private final T factorSetting;

        public FactorPredicate(BiPredicate<Double, T> predicate, T factorSetting) {
            this.predicate = predicate;
            this.factorSetting = factorSetting;
        }

        public FactorPredicate<?> negate() {
            return new FactorPredicate<T>(this.predicate.negate(), this.factorSetting);
        }

        public boolean test(double factor) {
            boolean result = this.predicate.test(factor, (Double)this.factorSetting);
            return result;
        }
    }
}

