/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.process.files;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.methods.MethodConverter;
import org.eclipse.chemclipse.converter.quantitation.QuantDBConverter;
import org.eclipse.chemclipse.converter.sequence.SequenceConverter;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.nmr.converter.core.ScanConverterNMR;
import org.eclipse.chemclipse.pcr.converter.core.PlateConverterPCR;
import org.eclipse.chemclipse.processing.converter.AbstractSupplierFileIdentifier;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;
import org.eclipse.chemclipse.wsd.converter.chromatogram.ChromatogramConverterWSD;
import org.eclipse.chemclipse.xir.converter.core.ScanConverterXIR;

public class SupplierFileIdentifier
extends AbstractSupplierFileIdentifier
implements ISupplierFileIdentifier {
    private String type = "";

    public SupplierFileIdentifier(DataType dataType) {
        super(SupplierFileIdentifier.getSupplier(dataType));
        this.initialize(dataType);
    }

    private static List<ISupplier> getSupplier(DataType dataType) {
        List<Object> supplier = new ArrayList<ISupplier>();
        switch (dataType) {
            case MSD_NOMINAL: 
            case MSD_TANDEM: 
            case MSD_HIGHRES: 
            case MSD: {
                supplier = ChromatogramConverterMSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case CSD: {
                supplier = ChromatogramConverterCSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case WSD: {
                supplier = ChromatogramConverterWSD.getInstance().getChromatogramConverterSupport().getSupplier();
                break;
            }
            case XIR: {
                supplier = ScanConverterXIR.getScanConverterSupport().getSupplier();
                break;
            }
            case NMR: {
                supplier = ScanConverterNMR.getScanConverterSupport().getSupplier();
                break;
            }
            case PCR: {
                supplier = PlateConverterPCR.getScanConverterSupport().getSupplier();
                break;
            }
            case SEQ: {
                supplier = SequenceConverter.getSequenceConverterSupport().getSupplier();
                break;
            }
            case MTH: {
                supplier = MethodConverter.getMethodConverterSupport().getSupplier();
            }
            case QDB: {
                supplier = QuantDBConverter.getQuantDBConverterSupport().getSupplier();
            }
        }
        return supplier;
    }

    private void initialize(DataType dataType) {
        switch (dataType) {
            case MSD_NOMINAL: 
            case MSD_TANDEM: 
            case MSD_HIGHRES: 
            case MSD: {
                this.type = "MSD";
                break;
            }
            case CSD: {
                this.type = "CSD";
                break;
            }
            case WSD: {
                this.type = "WSD";
                break;
            }
            case XIR: {
                this.type = "XIR";
                break;
            }
            case NMR: {
                this.type = "NMR";
                break;
            }
            case PCR: {
                this.type = "PCR";
                break;
            }
            case SEQ: {
                this.type = "SEQ";
                break;
            }
            case MTH: {
                this.type = "MTH";
                break;
            }
            case QDB: {
                this.type = "QDB";
                break;
            }
            default: {
                this.type = "";
            }
        }
    }

    public String getType() {
        return this.type;
    }
}

