/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.IC;
import org.eclipse.help.ui.internal.preferences.ICPreferences;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ICTable {
    private Table table;
    private TableViewer viewer;
    private final String NAME_COLUMN = Messages.RemoteICViewer_Name;
    private final String LOCATION_COLUMN = Messages.RemoteICViewer_URL;
    private final String STATUS_COLUMN = Messages.RemoteICViewer_Enabled;
    private String[] columnNames = new String[]{this.NAME_COLUMN, this.LOCATION_COLUMN, this.STATUS_COLUMN};

    public ICTable(Composite parent) {
        this.table = this.createTable(parent);
        this.viewer = this.createTableViewer();
        this.loadPreferences();
    }

    public void dispose() {
        this.viewer.getLabelProvider().dispose();
    }

    private Table createTable(Composite parent) {
        int style = 68354;
        TableLayout tableLayout = new TableLayout();
        Table table = new Table(parent, style);
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        gridData.heightHint = table.getItemHeight();
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(85), new ColumnWeightData(165), new ColumnWeightData(60)};
        tableLayout.addColumnData(fTableColumnLayouts[0]);
        TableColumn column = new TableColumn(table, 0, 0);
        column.setResizable(fTableColumnLayouts[0].resizable);
        column.setText(this.NAME_COLUMN);
        tableLayout.addColumnData(fTableColumnLayouts[1]);
        column = new TableColumn(table, 0, 1);
        column.setResizable(fTableColumnLayouts[1].resizable);
        column.setText(this.LOCATION_COLUMN);
        tableLayout.addColumnData(fTableColumnLayouts[2]);
        column = new TableColumn(table, 0, 2);
        column.setResizable(fTableColumnLayouts[2].resizable);
        column.setText(this.STATUS_COLUMN);
        return table;
    }

    private TableViewer createTableViewer() {
        TableViewer viewer = new TableViewer(this.table);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(this.columnNames);
        viewer.setContentProvider((IContentProvider)new ICContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ICLabelProvider());
        return viewer;
    }

    public void update(List<IC> ics) {
        this.viewer.getContentProvider().inputChanged((Viewer)this.viewer, null, ics);
        this.refresh();
    }

    public void refresh() {
        this.viewer.refresh(this.getICs());
    }

    public List<String> getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public List<IC> getICs() {
        ICContentProvider p = (ICContentProvider)this.viewer.getContentProvider();
        IC[] objs = p.getElements(null);
        ArrayList<IC> content = new ArrayList<IC>();
        int o = 0;
        while (o < objs.length) {
            content.add(objs[o]);
            ++o;
        }
        return content;
    }

    public void setICs(List<IC> ics) {
        List<IC> oldICs = this.getICs();
        int o = 0;
        while (o < oldICs.size()) {
            this.removeIC(oldICs.get(o));
            ++o;
        }
        int i = 0;
        while (i < ics.size()) {
            this.addIC(ics.get(i));
            ++i;
        }
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Table getTable() {
        return this.table;
    }

    public void addIC(IC ic) {
        List<IC> content = this.getICs();
        content.add(ic);
        this.getTableViewer().getContentProvider().inputChanged((Viewer)this.getTableViewer(), null, content);
        this.getTableViewer().add((Object)ic);
        this.refresh();
    }

    public void editIC(IC ic) {
        List<IC> content = this.getICs();
        content.set(this.getTable().getSelectionIndex(), ic);
        this.getTableViewer().replace((Object)ic, this.getTable().getSelectionIndex());
        this.getTableViewer().getContentProvider().inputChanged((Viewer)this.getTableViewer(), null, content);
        this.refresh();
    }

    public void removeIC(IC ic) {
        List<IC> content = this.getICs();
        content.remove(ic);
        this.getTableViewer().getContentProvider().inputChanged((Viewer)this.getTableViewer(), null, content);
        this.getTableViewer().remove((Object)ic);
        this.refresh();
    }

    private void loadPreferences() {
        List<IC> ics = ICPreferences.getICs();
        int i = 0;
        while (i < ics.size()) {
            this.addIC(ics.get(i));
            ++i;
        }
    }

    class ICContentProvider
    implements IStructuredContentProvider {
        private List<IC> content = new ArrayList<IC>();

        ICContentProvider() {
        }

        public void dispose() {
            this.content = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.content = (List)newInput;
        }

        public IC[] getElements(Object inputElement) {
            return this.content.toArray(new IC[this.content.size()]);
        }
    }

    public class ICLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((IC)element).getName();
                }
                case 1: {
                    return ((IC)element).getHref();
                }
                case 2: {
                    return ((IC)element).isEnabled() ? Messages.RemoteICLabelProvider_4 : Messages.RemoteICLabelProvider_5;
                }
            }
            return null;
        }
    }
}

