/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.preferences.PreferenceInitializer;

public class ResourceSupport {
    public static final String ICON_SET_RANGE = "set_range.gif";
    public static final String ICON_HIDE = "hide.gif";
    public static final String ICON_RESET = "reset.gif";
    public static final String ICON_CHECKED = "checked.gif";
    public static final String ICON_UNCHECKED = "unchecked.gif";
    public static final String ICON_LEGEND = "legend.gif";
    public static final String ICON_POSITION = "position.gif";
    public static final String ICON_SETTINGS = "preferences.gif";
    public static final String ICON_MAPPINGS = "mappings.gif";
    public static final String ICON_DELETE = "delete.gif";
    public static final String ICON_DELETE_ALL = "deleteAll.gif";
    public static final String ARROW_LEFT = "arrowLeft.gif";
    public static final String ARROW_RIGHT = "arrowRight.gif";
    public static final String ARROW_UP = "arrowUp.gif";
    public static final String ARROW_DOWN = "arrowDown.gif";
    private static final Map<RGB, Color> colorMap = new HashMap<RGB, Color>();
    private static final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static IPreferenceStore preferenceStore = null;
    private static ImageRegistry imageRegistry = null;

    private ResourceSupport() {
    }

    public static Color getColor(RGB rgb) {
        Color color = colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getDefault(), rgb);
            colorMap.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        return ResourceSupport.getColor(rgb);
    }

    public static IPreferenceStore getPreferenceStore() {
        if (preferenceStore == null) {
            String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".eclipseswtchartsettings";
            preferenceStore = new PreferenceStore(filename);
            PreferenceInitializer preferenceInitializer = new PreferenceInitializer();
            preferenceInitializer.initializeDefaultPreferences();
        }
        return preferenceStore;
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            imageRegistry = ResourceSupport.initializeImageRegistry();
        }
        return resourceManager.createImage(imageRegistry.getDescriptor(key));
    }

    protected void finalize() throws Throwable {
        for (Color color : colorMap.values()) {
            if (color == null) continue;
            color.dispose();
        }
        super.finalize();
    }

    private static ImageRegistry initializeImageRegistry() {
        if (Display.getCurrent() == null) {
            throw new SWTException(22);
        }
        imageRegistry = new ImageRegistry();
        HashSet<String> imageSet = new HashSet<String>();
        imageSet.add(ICON_SET_RANGE);
        imageSet.add(ICON_HIDE);
        imageSet.add(ICON_RESET);
        imageSet.add(ICON_CHECKED);
        imageSet.add(ICON_UNCHECKED);
        imageSet.add(ICON_LEGEND);
        imageSet.add(ICON_POSITION);
        imageSet.add(ICON_SETTINGS);
        imageSet.add(ICON_MAPPINGS);
        imageSet.add(ICON_DELETE);
        imageSet.add(ICON_DELETE_ALL);
        imageSet.add(ARROW_LEFT);
        imageSet.add(ARROW_RIGHT);
        imageSet.add(ARROW_UP);
        imageSet.add(ARROW_DOWN);
        for (String image : imageSet) {
            imageRegistry.put(image, ResourceSupport.createImageDescriptor(image));
        }
        return imageRegistry;
    }

    private static ImageDescriptor createImageDescriptor(String fileName) {
        URL url = ResourceSupport.class.getResource("/resources/icons/16x16/" + fileName);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

