/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.primitive.LongBags;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.factory.primitive.LongSets;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;

public class CollectLongIterable<T>
extends AbstractLazyLongIterable {
    private final LazyIterable<T> iterable;
    private final LongFunction<? super T> function;
    private final LongFunctionToProcedure<T> longFunctionToProcedure;

    public CollectLongIterable(LazyIterable<T> adapted, LongFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.longFunctionToProcedure = new LongFunctionToProcedure<T>(function);
    }

    public LongIterator longIterator() {
        return new LongIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectLongIterable.this.iterable.iterator();
            }

            public long next() {
                return CollectLongIterable.this.function.longValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void each(LongProcedure procedure) {
        this.iterable.forEachWith(this.longFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.iterable.count((Predicate & Serializable)each -> predicate.accept(this.function.longValueOf(each)));
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.iterable.anySatisfy((Predicate & Serializable)each -> predicate.accept(this.function.longValueOf(each)));
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.iterable.allSatisfy((Predicate & Serializable)each -> predicate.accept(this.function.longValueOf(each)));
    }

    @Override
    public long[] toArray() {
        long[] array = new long[this.size()];
        this.iterable.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            array[index] = this.function.longValueOf(each);
        });
        return array;
    }

    @Override
    public long[] toSortedArray() {
        long[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableLongList toList() {
        return LongLists.mutable.withAll((LongIterable)this);
    }

    @Override
    public MutableLongSet toSet() {
        return LongSets.mutable.withAll((LongIterable)this);
    }

    @Override
    public MutableLongBag toBag() {
        return LongBags.mutable.withAll((LongIterable)this);
    }

    @Override
    public boolean containsAll(long ... source) {
        for (long value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(LongIterable source) {
        LongIterator iterator = source.longIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class LongFunctionToProcedure<T>
    implements Procedure2<T, LongProcedure> {
        private static final long serialVersionUID = 1L;
        private final LongFunction<? super T> function;

        private LongFunctionToProcedure(LongFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, LongProcedure procedure) {
            procedure.value(this.function.longValueOf(each));
        }
    }
}

