/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.MutableLongValuesMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedLongCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public abstract class AbstractMutableLongValuesMap
extends AbstractLongIterable
implements MutableLongValuesMap {
    protected abstract int getOccupiedWithData();

    protected abstract SentinelValues getSentinelValues();

    protected abstract void setSentinelValuesNull();

    protected abstract long getEmptyValue();

    protected abstract long getValueAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract boolean isNonSentinelAtIndex(int var1);

    protected void addEmptyKeyValue(long value) {
        this.getSentinelValues().containsZeroKey = true;
        this.getSentinelValues().zeroValue = value;
    }

    protected void removeEmptyKey() {
        if (this.getSentinelValues().containsOneKey) {
            this.getSentinelValues().containsZeroKey = false;
            this.getSentinelValues().zeroValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    protected void addRemovedKeyValue(long value) {
        this.getSentinelValues().containsOneKey = true;
        this.getSentinelValues().oneValue = value;
    }

    protected void removeRemovedKey() {
        if (this.getSentinelValues().containsZeroKey) {
            this.getSentinelValues().containsOneKey = false;
            this.getSentinelValues().oneValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    public boolean contains(long value) {
        return this.containsValue(value);
    }

    public boolean containsAll(LongIterable source) {
        return source.allSatisfy((LongPredicate & Serializable)value -> this.contains(value));
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableLongIterator iterator = this.longIterator();
        long max = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableLongIterator iterator = this.longIterator();
        long min = iterator.next();
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int size() {
        return this.getOccupiedWithData() + (this.getSentinelValues() == null ? 0 : this.getSentinelValues().size());
    }

    public boolean isEmpty() {
        return this.getOccupiedWithData() == 0 && (this.getSentinelValues() == null || this.getSentinelValues().size() == 0);
    }

    public boolean notEmpty() {
        return this.getOccupiedWithData() != 0 || this.getSentinelValues() != null && this.getSentinelValues().size() != 0;
    }

    public void each(LongProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(this.getSentinelValues().zeroValue));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getSentinelValues().oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!this.isNonSentinelAtIndex(i)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getValueAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                array[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                array[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            array[index] = this.getValueAtIndex(i);
            ++index;
        }
        return array;
    }

    public long[] toArray(long[] target) {
        if (target.length < this.size()) {
            target = new long[this.size()];
        }
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                target[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                target[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            target[index] = this.getValueAtIndex(i);
            ++index;
        }
        return target;
    }

    public MutableLongBag select(LongPredicate predicate) {
        return (MutableLongBag)this.select(predicate, (MutableLongCollection)new LongHashBag());
    }

    public MutableLongBag reject(LongPredicate predicate) {
        return (MutableLongBag)this.reject(predicate, (MutableLongCollection)new LongHashBag());
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return (MutableBag)this.collect(function, (Collection)Bags.mutable.withInitialCapacity(this.size()));
    }

    public long detectIfNone(LongPredicate predicate, long value) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return this.getValueAtIndex(i);
        }
        return value;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || predicate.accept(this.getValueAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)LongBags.mutable.withAll((LongIterable)this));
            } else {
                MutableLongIterator iterator = this.longIterator();
                while (iterator.hasNext()) {
                    MutableLongBag batch = LongBags.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey) {
                result += this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            result += this.getValueAtIndex(i);
        }
        return result;
    }

    public boolean containsValue(long value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(LongProcedure procedure) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            procedure.value(this.getValueAtIndex(i));
        }
    }

    protected abstract class AbstractLongValuesCollection
    implements MutableLongCollection {
        protected AbstractLongValuesCollection() {
        }

        public void clear() {
            AbstractMutableLongValuesMap.this.clear();
        }

        public MutableLongCollection select(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.select(predicate);
        }

        public MutableLongCollection reject(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.reject(predicate);
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            return AbstractMutableLongValuesMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
            return AbstractMutableLongValuesMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            return (T)AbstractMutableLongValuesMap.this.injectInto(injectedValue, function);
        }

        public RichIterable<LongIterable> chunk(int size) {
            return AbstractMutableLongValuesMap.this.chunk(size);
        }

        public long sum() {
            return AbstractMutableLongValuesMap.this.sum();
        }

        public long max() {
            return AbstractMutableLongValuesMap.this.max();
        }

        public long maxIfEmpty(long defaultValue) {
            return AbstractMutableLongValuesMap.this.maxIfEmpty(defaultValue);
        }

        public long min() {
            return AbstractMutableLongValuesMap.this.min();
        }

        public long minIfEmpty(long defaultValue) {
            return AbstractMutableLongValuesMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return AbstractMutableLongValuesMap.this.average();
        }

        public double median() {
            return AbstractMutableLongValuesMap.this.median();
        }

        public long[] toSortedArray() {
            return AbstractMutableLongValuesMap.this.toSortedArray();
        }

        public MutableLongList toSortedList() {
            return AbstractMutableLongValuesMap.this.toSortedList();
        }

        public MutableLongCollection with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongCollection asUnmodifiable() {
            return UnmodifiableLongCollection.of(this);
        }

        public MutableLongCollection asSynchronized() {
            return SynchronizedLongCollection.of(this);
        }

        public ImmutableLongCollection toImmutable() {
            return LongLists.immutable.withAll((LongIterable)this);
        }

        public boolean contains(long value) {
            return AbstractMutableLongValuesMap.this.containsValue(value);
        }

        public boolean containsAll(long ... source) {
            return AbstractMutableLongValuesMap.this.containsAll(source);
        }

        public boolean containsAll(LongIterable source) {
            return AbstractMutableLongValuesMap.this.containsAll(source);
        }

        public MutableLongList toList() {
            return AbstractMutableLongValuesMap.this.toList();
        }

        public MutableLongSet toSet() {
            return AbstractMutableLongValuesMap.this.toSet();
        }

        public MutableLongBag toBag() {
            return AbstractMutableLongValuesMap.this.toBag();
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public boolean isEmpty() {
            return AbstractMutableLongValuesMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return AbstractMutableLongValuesMap.this.notEmpty();
        }

        public String makeString() {
            return AbstractMutableLongValuesMap.this.makeString();
        }

        public String makeString(String separator) {
            return AbstractMutableLongValuesMap.this.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return AbstractMutableLongValuesMap.this.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            AbstractMutableLongValuesMap.this.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            AbstractMutableLongValuesMap.this.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            AbstractMutableLongValuesMap.this.appendString(appendable, start, separator, end);
        }

        public void each(LongProcedure procedure) {
            AbstractMutableLongValuesMap.this.each(procedure);
        }

        public int count(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.count(predicate);
        }

        public boolean anySatisfy(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return AbstractMutableLongValuesMap.this.noneSatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = AbstractMutableLongValuesMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != AbstractMutableLongValuesMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = AbstractMutableLongValuesMap.this.size();
            for (long item : source) {
                this.remove(item);
            }
            return oldSize != AbstractMutableLongValuesMap.this.size();
        }

        public boolean retainAll(long ... source) {
            return this.retainAll(LongHashSet.newSetWith(source));
        }

        public int size() {
            return AbstractMutableLongValuesMap.this.size();
        }

        public long[] toArray() {
            return AbstractMutableLongValuesMap.this.toArray();
        }

        public long[] toArray(long[] target) {
            return AbstractMutableLongValuesMap.this.toArray(target);
        }
    }

    protected static class SentinelValues
    extends AbstractSentinelValues {
        protected long zeroValue;
        protected long oneValue;

        protected SentinelValues() {
        }

        public boolean containsValue(long value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }

        public SentinelValues copy() {
            SentinelValues sentinelValues = new SentinelValues();
            sentinelValues.zeroValue = this.zeroValue;
            sentinelValues.oneValue = this.oneValue;
            sentinelValues.containsOneKey = this.containsOneKey;
            sentinelValues.containsZeroKey = this.containsZeroKey;
            return sentinelValues;
        }
    }
}

