/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableFloatListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableFloatSingletonList;

public class ImmutableFloatListFactoryImpl
implements ImmutableFloatListFactory {
    @Override
    public ImmutableFloatList empty() {
        return ImmutableFloatEmptyList.INSTANCE;
    }

    @Override
    public ImmutableFloatList of() {
        return this.empty();
    }

    @Override
    public ImmutableFloatList with() {
        return this.empty();
    }

    @Override
    public ImmutableFloatList of(float one) {
        return this.with(one);
    }

    @Override
    public ImmutableFloatList with(float one) {
        return new ImmutableFloatSingletonList(one);
    }

    @Override
    public ImmutableFloatList of(float ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableFloatList with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayList.newListWith(items);
    }

    @Override
    public ImmutableFloatList ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableFloatList withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatList) {
            return (ImmutableFloatList)items;
        }
        return this.with(items.toArray());
    }
}

