/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.map.primitive.MutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;

/**
 * A factory which creates instances of type {@link MutableDoubleLongMap}.
 * This file was automatically generated from template file mutablePrimitivePrimitiveMapFactory.stg.
 *
 * @since 6.0.
 */
public interface MutableDoubleLongMapFactory
{
    MutableDoubleLongMap empty();

    /**
     * Same as {@link #empty()}.
     */
    MutableDoubleLongMap of();

    /**
     * Same as {@link #empty()}.
     */
    MutableDoubleLongMap with();

    /**
     * Same as {@link #withAll(DoubleLongMap)}.
     */
    MutableDoubleLongMap ofAll(DoubleLongMap map);

    MutableDoubleLongMap withAll(DoubleLongMap map);
}
