/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharCharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyCharIterate;

final class ImmutableCharCharEmptyMap
implements ImmutableCharCharMap,
Serializable {
    static final ImmutableCharCharMap INSTANCE = new ImmutableCharCharEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';

    ImmutableCharCharEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public char get(char key) {
        return '\u0000';
    }

    @Override
    public char getIfAbsent(char key, char ifAbsent) {
        return ifAbsent;
    }

    @Override
    public char getOrThrow(char key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(char key) {
        return false;
    }

    @Override
    public boolean containsValue(char value) {
        return false;
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
    }

    @Override
    public void forEachKeyValue(CharCharProcedure procedure) {
    }

    @Override
    public LazyCharIterable keysView() {
        return LazyCharIterate.empty();
    }

    @Override
    public RichIterable<CharCharPair> keyValuesView() {
        return LazyIterate.empty();
    }

    @Override
    public ImmutableCharCharMap flipUniqueValues() {
        return CharCharMaps.immutable.empty();
    }

    @Override
    public ImmutableCharCharMap select(CharCharPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableCharCharMap reject(CharCharPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableCharCharMap toImmutable() {
        return this;
    }

    @Override
    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    @Override
    public void forEach(CharProcedure procedure) {
    }

    @Override
    public void each(CharProcedure procedure) {
    }

    @Override
    public int count(CharPredicate predicate) {
        return 0;
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public char min() {
        throw new NoSuchElementException();
    }

    @Override
    public char max() {
        throw new NoSuchElementException();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public char[] toSortedArray() {
        return new char[0];
    }

    @Override
    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    @Override
    public ImmutableCharBag select(CharPredicate predicate) {
        return CharBags.immutable.empty();
    }

    @Override
    public ImmutableCharBag reject(CharPredicate predicate) {
        return CharBags.immutable.empty();
    }

    @Override
    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public char[] toArray() {
        return new char[0];
    }

    @Override
    public boolean contains(char value) {
        return false;
    }

    @Override
    public boolean containsAll(char ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableCharList toList() {
        return new CharArrayList();
    }

    @Override
    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    @Override
    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public ImmutableCharCharMap newWithKeyValue(char key, char value) {
        return new ImmutableCharCharSingletonMap(key, value);
    }

    @Override
    public ImmutableCharCharMap newWithoutKey(char key) {
        return this;
    }

    @Override
    public ImmutableCharCharMap newWithoutAllKeys(CharIterable keys) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(new CharArrayList());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap map = (CharCharMap)obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

