/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableFloatSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import org.eclipse.collections.impl.set.primitive.AbstractFloatSet;

public final class FloatHashSet
extends AbstractFloatSet
implements MutableFloatSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float EMPTY = 0.0f;
    private static final float REMOVED = 1.0f;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private float[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public FloatHashSet() {
        this.allocateTable(16);
    }

    public FloatHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public FloatHashSet(float ... elements) {
        this();
        this.addAll(elements);
    }

    public FloatHashSet(FloatHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static FloatHashSet newSet(FloatIterable source) {
        if (source instanceof FloatHashSet) {
            return new FloatHashSet((FloatHashSet)source);
        }
        return FloatHashSet.newSetWith(source.toArray());
    }

    public static FloatHashSet newSetWith(float ... source) {
        return new FloatHashSet(source);
    }

    private static boolean isBetweenZeroAndThirtyOne(float value) {
        return Float.compare(value, 0.0f) >= 0 && Float.compare(value, 31.0f) <= 0 && Double.compare(value, Math.floor(value)) == 0;
    }

    @Override
    public int hashCode() {
        float value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += Float.floatToIntBits(value);
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                result += Float.floatToIntBits(this.table[i]);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            float value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean add(float element) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << (int)element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (Float.compare(this.table[index], element) == 0) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (Float.compare(this.table[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    @Override
    public boolean addAll(float ... source) {
        int oldSize = this.size();
        for (float item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean addAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatHashSet) {
            FloatHashSet hashSet = (FloatHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (float item : hashSet.table) {
                if (!FloatHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean remove(float value) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << (int)value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (Float.compare(this.table[index], value) == 0) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(FloatIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof FloatHashSet) {
            FloatHashSet hashSet = (FloatHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (float item : hashSet.table) {
                if (!FloatHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                float item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(float ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (float item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(FloatIterable source) {
        int oldSize = this.size();
        FloatSet sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
        FloatHashSet retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(float ... source) {
        return this.retainAll(FloatHashSet.newSetWith(source));
    }

    @Override
    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new float[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0.0f);
        }
    }

    @Override
    public FloatHashSet with(float element) {
        this.add(element);
        return this;
    }

    @Override
    public FloatHashSet without(float element) {
        this.remove(element);
        return this;
    }

    @Override
    public FloatHashSet withAll(FloatIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    @Override
    public FloatHashSet withoutAll(FloatIterable elements) {
        this.removeAll(elements);
        return this;
    }

    @Override
    public MutableFloatSet asUnmodifiable() {
        return new UnmodifiableFloatSet(this);
    }

    @Override
    public MutableFloatSet asSynchronized() {
        return new SynchronizedFloatSet(this);
    }

    @Override
    public ImmutableFloatSet toImmutable() {
        if (this.size() == 0) {
            return FloatSets.immutable.with();
        }
        if (this.size() == 1) {
            return FloatSets.immutable.with(this.floatIterator().next());
        }
        FloatHashSet mutableSet = FloatHashSet.newSetWith(this.toArray());
        return new ImmutableFloatHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    @Override
    public MutableFloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    @Override
    public float[] toArray() {
        float value;
        float[] array = new float[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            array[j] = value = (float)Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    @Override
    public boolean contains(float value) {
        if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> (int)value & 1) != 0;
        }
        return Float.compare(this.table[this.probe(value)], value) == 0;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    @Override
    public FloatHashSet select(FloatPredicate predicate) {
        return this.select(predicate, new FloatHashSet());
    }

    @Override
    public <R extends MutableFloatCollection> R select(FloatPredicate predicate, R target) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            target.add(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public FloatHashSet reject(FloatPredicate predicate) {
        return this.reject(predicate, new FloatHashSet());
    }

    @Override
    public <R extends MutableFloatCollection> R reject(FloatPredicate predicate, R target) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            target.add(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            target.add(value2);
        }
        return target;
    }

    @Override
    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.collect(function, UnifiedSet.newSet(this.size()));
    }

    @Override
    public <V, R extends Collection<V>> R collect(FloatToObjectFunction<? extends V> function, R target) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    @Override
    public int count(FloatPredicate predicate) {
        float value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        float value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public double sum() {
        float value;
        double result = 0.0;
        double compensation = 0.0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            double adjustedValue = (double)value - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            double adjustedValue = (double)value2 - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    @Override
    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (float value : this.table) {
            if (!FloatHashSet.isNonSentinel(value) || isMaxSet && Float.compare(max, value) >= 0) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (float value : this.table) {
            if (!FloatHashSet.isNonSentinel(value) || isMinSet && Float.compare(value, min) >= 0) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    @Override
    public FloatSet freeze() {
        if (this.size() == 0) {
            return FloatSets.immutable.with();
        }
        if (this.size() == 1) {
            return FloatSets.immutable.with(this.floatIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableFloatHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        float value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeFloat(value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            out.writeFloat(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readFloat());
        }
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        float value;
        T result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (float value2 : this.table) {
            if (!FloatHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        float[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new float[sizeToAllocate];
    }

    int probe(float element) {
        int index = this.spreadAndMask(element);
        float valueAtIndex = this.table[index];
        if (Float.compare(valueAtIndex, element) == 0 || Float.compare(valueAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(valueAtIndex, 1.0f) == 0 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            valueAtIndex = this.table[nextIndex];
            if (Float.compare(valueAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(valueAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(float element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.table.length - 1;
            float valueAtIndex = this.table[nextIndex];
            if (Float.compare(valueAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(valueAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(float element, int removedIndex) {
        int nextIndex = Integer.reverse(SpreadFunctions.floatSpreadOne(element));
        int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
        float valueAtIndex;
        while (Float.compare(valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Float.compare(valueAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(float element) {
        int code = SpreadFunctions.floatSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(float element) {
        int code = SpreadFunctions.floatSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        float[] copy = new float[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, this.table.length);
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(float value) {
        return Float.compare(value, 0.0f) != 0 && Float.compare(value, 1.0f) != 0;
    }

    private static final class ImmutableFloatHashSet
    extends AbstractImmutableFloatSet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableFloatHashSet(float[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use FloatSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableFloatSet newSetWith(float ... elements) {
            return FloatHashSet.newSetWith(elements).toImmutable();
        }

        @Override
        public int hashCode() {
            float value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += Float.floatToIntBits(value);
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                    result += Float.floatToIntBits(this.table[i]);
                }
            }
            return result;
        }

        @Override
        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                float value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (float value2 : this.table) {
                    if (!FloatHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FloatIterator floatIterator() {
            return new InternalFloatIterator();
        }

        @Override
        public float[] toArray() {
            float value;
            float[] array = new float[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                array[j] = value = (float)Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!FloatHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        @Override
        public boolean contains(float value) {
            if (FloatHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> (int)value & 1) != 0;
            }
            return Float.compare(this.table[this.probe(value)], value) == 0;
        }

        @Override
        public void forEach(FloatProcedure procedure) {
            this.each(procedure);
        }

        @Override
        public void each(FloatProcedure procedure) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        @Override
        public ImmutableFloatSet select(FloatPredicate predicate) {
            return this.select(predicate, new FloatHashSet()).toImmutable();
        }

        @Override
        public ImmutableFloatSet reject(FloatPredicate predicate) {
            return this.reject(predicate, new FloatHashSet()).toImmutable();
        }

        @Override
        public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet set = this.collect(function, UnifiedSet.newSet(this.size()));
            return set.toImmutable();
        }

        @Override
        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        @Override
        public int count(FloatPredicate predicate) {
            float value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public boolean anySatisfy(FloatPredicate predicate) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean allSatisfy(FloatPredicate predicate) {
            float value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean noneSatisfy(FloatPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        @Override
        public double sum() {
            float value;
            double result = 0.0;
            double compensation = 0.0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                double adjustedValue = (double)value - compensation;
                double nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                double adjustedValue = (double)value2 - compensation;
                double nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            return result;
        }

        @Override
        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (float value : this.table) {
                if (!FloatHashSet.isNonSentinel(value) || isMaxSet && Float.compare(max, value) >= 0) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        @Override
        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (float value : this.table) {
                if (!FloatHashSet.isNonSentinel(value) || isMinSet && Float.compare(value, min) >= 0) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            float value;
            T result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << (int)value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (float value2 : this.table) {
                if (!FloatHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        private Object writeReplace() {
            return new ImmutableFloatSetSerializationProxy(this);
        }

        int probe(float element) {
            int index = this.spreadAndMask(element);
            float valueAtIndex = this.table[index];
            if (Float.compare(valueAtIndex, element) == 0 || Float.compare(valueAtIndex, 0.0f) == 0) {
                return index;
            }
            int removedIndex = Float.compare(valueAtIndex, 1.0f) == 0 ? index : -1;
            for (int i = 1; i < 8; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                valueAtIndex = this.table[nextIndex];
                if (Float.compare(valueAtIndex, element) == 0) {
                    return nextIndex;
                }
                if (Float.compare(valueAtIndex, 0.0f) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeTwo(element, removedIndex);
        }

        int probeTwo(float element, int removedIndex) {
            int index = this.spreadTwoAndMask(element);
            for (int i = 0; i < 8; ++i) {
                int nextIndex = index + i & this.table.length - 1;
                float valueAtIndex = this.table[nextIndex];
                if (Float.compare(valueAtIndex, element) == 0) {
                    return nextIndex;
                }
                if (Float.compare(valueAtIndex, 0.0f) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return this.probeThree(element, removedIndex);
        }

        int probeThree(float element, int removedIndex) {
            int nextIndex = Integer.reverse(SpreadFunctions.floatSpreadOne(element));
            int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
            float valueAtIndex;
            while (Float.compare(valueAtIndex = this.table[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
                if (Float.compare(valueAtIndex, 0.0f) == 0) {
                    return removedIndex == -1 ? nextIndex : removedIndex;
                }
                if (Float.compare(valueAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
                removedIndex = nextIndex;
            }
            return nextIndex;
        }

        int spreadAndMask(float element) {
            int code = SpreadFunctions.floatSpreadOne(element);
            return this.mask(code);
        }

        int spreadTwoAndMask(float element) {
            int code = SpreadFunctions.floatSpreadTwo(element);
            return this.mask(code);
        }

        private int mask(int spread) {
            return spread & this.table.length - 1;
        }

        private class InternalFloatIterator
        implements FloatIterator {
            private int count;
            private int position;
            private float zeroToThirtyOne;

            private InternalFloatIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.count < ImmutableFloatHashSet.this.size();
            }

            @Override
            public float next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32.0f) {
                    if (ImmutableFloatHashSet.this.contains(this.zeroToThirtyOne)) {
                        float result = this.zeroToThirtyOne;
                        this.zeroToThirtyOne += 1.0f;
                        return result;
                    }
                    this.zeroToThirtyOne += 1.0f;
                }
                float[] table = ImmutableFloatHashSet.this.table;
                while (!FloatHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                float result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }

    private class InternalFloatIterator
    implements MutableFloatIterator {
        private int count;
        private int position;
        private float zeroToThirtyOne;

        private InternalFloatIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < FloatHashSet.this.size();
        }

        @Override
        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32.0f) {
                if (FloatHashSet.this.contains(this.zeroToThirtyOne)) {
                    float result = this.zeroToThirtyOne;
                    this.zeroToThirtyOne += 1.0f;
                    return result;
                }
                this.zeroToThirtyOne += 1.0f;
            }
            float[] table = FloatHashSet.this.table;
            while (!FloatHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            float result = table[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            float removeValue;
            if (this.count == 0) {
                throw new IllegalStateException();
            }
            if (this.zeroToThirtyOne <= 32.0f && this.position == 0) {
                if (FloatHashSet.this.zeroToThirtyOne != (FloatHashSet.this.zeroToThirtyOne | 1 << (int)this.zeroToThirtyOne - 1)) {
                    throw new IllegalStateException();
                }
                removeValue = this.zeroToThirtyOne - 1.0f;
            } else {
                if (Float.compare(FloatHashSet.this.table[this.position - 1], 1.0f) == 0) {
                    throw new IllegalStateException();
                }
                removeValue = FloatHashSet.this.table[this.position - 1];
            }
            FloatHashSet.this.remove(removeValue);
            --this.count;
        }
    }
}

