/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.wizard.template.BooleanTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.ContainerTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.GroupTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.ProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.StringSelectionTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.StringTemplateVariable;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;
import org.eclipse.xtext.xbase.lib.Pair;

@Beta
public abstract class AbstractTemplate {
    private static final Logger logger = Logger.getLogger(AbstractTemplate.class);
    protected List<TemplateVariable> variables = new ArrayList<TemplateVariable>();

    protected StringTemplateVariable text(String name, String defaultValue) {
        return this.text(name, defaultValue, null, null);
    }

    protected StringTemplateVariable text(String name, String defaultValue, ContainerTemplateVariable container) {
        return this.text(name, defaultValue, null, container);
    }

    protected StringTemplateVariable text(String name, String defaultValue, String description) {
        return this.text(name, defaultValue, description, null);
    }

    protected StringTemplateVariable text(String name, String defaultValue, String description, ContainerTemplateVariable container) {
        StringTemplateVariable variable = new StringTemplateVariable(name, defaultValue, description, container);
        this.variables.add(variable);
        return variable;
    }

    protected BooleanTemplateVariable check(String name, boolean defaultValue) {
        return this.check(name, defaultValue, null, null);
    }

    protected BooleanTemplateVariable check(String name, boolean defaultValue, ContainerTemplateVariable container) {
        return this.check(name, defaultValue, null, container);
    }

    protected BooleanTemplateVariable check(String name, boolean defaultValue, String description) {
        return this.check(name, defaultValue, description, null);
    }

    protected BooleanTemplateVariable check(String name, boolean defaultValue, String description, ContainerTemplateVariable container) {
        BooleanTemplateVariable variable = new BooleanTemplateVariable(name, defaultValue, description, container);
        this.variables.add(variable);
        return variable;
    }

    protected StringSelectionTemplateVariable combo(String name, String[] possibleValues) {
        return this.combo(name, possibleValues, null, null);
    }

    protected StringSelectionTemplateVariable combo(String name, String[] possibleValues, ContainerTemplateVariable container) {
        return this.combo(name, possibleValues, null, container);
    }

    protected StringSelectionTemplateVariable combo(String name, String[] possibleValues, String description) {
        return this.combo(name, possibleValues, description, null);
    }

    protected StringSelectionTemplateVariable combo(String name, String[] possibleValues, String description, ContainerTemplateVariable container) {
        StringSelectionTemplateVariable variable = new StringSelectionTemplateVariable(name, possibleValues, description, container);
        this.variables.add(variable);
        return variable;
    }

    protected GroupTemplateVariable group(String name) {
        return this.group(name, null, null);
    }

    protected GroupTemplateVariable group(String name, ContainerTemplateVariable container) {
        return this.group(name, null, container);
    }

    protected GroupTemplateVariable group(String name, String description) {
        return this.group(name, description, null);
    }

    protected GroupTemplateVariable group(String name, String description, ContainerTemplateVariable container) {
        GroupTemplateVariable variable = new GroupTemplateVariable(name, description, container);
        this.variables.add(variable);
        return variable;
    }

    public String getLabel() {
        return this.getLocalizedValue("Label");
    }

    public String getIcon() {
        return this.getProjectTemplateAnnotation().icon();
    }

    public String getDescription() {
        return this.getLocalizedValue("Description");
    }

    protected String getLocalizedValue(String fieldName) {
        try {
            return (String)this.getClass().getClassLoader().loadClass(String.valueOf(this.getClass().getPackage().getName()) + ".Messages").getField(String.valueOf(this.getClass().getSimpleName()) + "_" + fieldName).get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error((Object)("Can not determine '" + fieldName + "'"), (Throwable)e);
            return "NOT AVAILABLE";
        }
    }

    public List<TemplateVariable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    protected IStatus validate() {
        return Status.OK_STATUS;
    }

    protected void updateVariables() {
    }

    protected ProjectTemplate getProjectTemplateAnnotation() {
        Class<?> projectTemplateClass = this.getClass();
        ProjectTemplate projectTemplateAnnotation = projectTemplateClass.getAnnotation(ProjectTemplate.class);
        if (projectTemplateAnnotation == null) {
            throw new RuntimeException("Template class '" + projectTemplateClass.getName() + "' does not declare a '" + ProjectTemplate.class.getName() + "' annotation");
        }
        return projectTemplateAnnotation;
    }

    protected List<Pair<String, Image>> getImages() {
        return new ArrayList<Pair<String, Image>>();
    }
}

