/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.image.ImageHeaderPICT;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public final class PICT
extends Metafile {
    private static final POILogger LOG = POILogFactory.getLogger(PICT.class);

    @Override
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        try {
            byte[] macheader = new byte[512];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(macheader);
            int pos = 16 * this.getUIDInstanceCount();
            byte[] pict = this.read(rawdata, pos);
            out.write(pict);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(byte[] data, int pos) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Metafile.Header header = new Metafile.Header();
        header.read(data, pos);
        long bs_exp = (long)pos + (long)header.getSize();
        long bs_act = bis.skip(bs_exp);
        if (bs_exp != bs_act) {
            throw new EOFException();
        }
        byte[] chunk = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream(header.getWmfSize());
        try (InflaterInputStream inflater = new InflaterInputStream(bis);){
            int count;
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
                PICT.bytefill(chunk, (byte)0);
            }
        }
        return out.toByteArray();
    }

    @Override
    public void setData(byte[] data) throws IOException {
        int nOffset = 512;
        ImageHeaderPICT nHeader = new ImageHeaderPICT(data, 512);
        Metafile.Header header = new Metafile.Header();
        int wmfSize = data.length - 512;
        header.setWmfSize(wmfSize);
        byte[] compressed = PICT.compress(data, 512, wmfSize);
        header.setZipSize(compressed.length);
        header.setBounds(nHeader.getBounds());
        Dimension nDim = nHeader.getSize();
        header.setDimension(new Dimension(Units.toEMU(nDim.getWidth()), Units.toEMU(nDim.getHeight())));
        byte[] checksum = PICT.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        if (this.getUIDInstanceCount() == 2) {
            out.write(checksum);
        }
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public PictureData.PictureType getType() {
        return PictureData.PictureType.PICT;
    }

    @Override
    public int getSignature() {
        return this.getUIDInstanceCount() == 1 ? 21536 : 21552;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 21536: {
                this.setUIDInstanceCount(1);
                break;
            }
            case 21552: {
                this.setUIDInstanceCount(2);
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for PICT");
            }
        }
    }

    private static void bytefill(byte[] array, byte value) {
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }
}

