/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.util.BitField;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class PersistPtrHolder
extends PositionDependentRecordAtom {
    private static final int MAX_RECORD_LENGTH = 100000;
    private final byte[] _header;
    private byte[] _ptrData;
    private long _type;
    private Map<Integer, Integer> _slideLocations;
    private static final BitField persistIdFld = new BitField(1048575);
    private static final BitField cntPersistFld = new BitField(-1048576);

    @Override
    public long getRecordType() {
        return this._type;
    }

    public int[] getKnownSlideIDs() {
        int[] ids = new int[this._slideLocations.size()];
        int i = 0;
        for (Integer slideId : this._slideLocations.keySet()) {
            ids[i++] = slideId;
        }
        return ids;
    }

    public Map<Integer, Integer> getSlideLocationsLookup() {
        return Collections.unmodifiableMap(this._slideLocations);
    }

    protected PersistPtrHolder(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        this._slideLocations = new HashMap<Integer, Integer>();
        this._ptrData = IOUtils.safelyAllocate(len - 8, 100000);
        System.arraycopy(source, start + 8, this._ptrData, 0, this._ptrData.length);
        int pos = 0;
        while (pos < this._ptrData.length) {
            int info = LittleEndian.getInt(this._ptrData, pos);
            int offset_no = persistIdFld.getValue(info);
            int offset_count = cntPersistFld.getValue(info);
            pos += 4;
            for (int i = 0; i < offset_count; ++i) {
                int sheet_no = offset_no + i;
                int sheet_offset = (int)LittleEndian.getUInt(this._ptrData, pos);
                this._slideLocations.put(sheet_no, sheet_offset);
                pos += 4;
            }
        }
    }

    public void clear() {
        this._slideLocations.clear();
    }

    public void addSlideLookup(int slideID, int posOnDisk) {
        if (this._slideLocations.containsKey(slideID)) {
            throw new CorruptPowerPointFileException("A record with persistId " + slideID + " already exists.");
        }
        this._slideLocations.put(slideID, posOnDisk);
    }

    @Override
    public void updateOtherRecordReferences(Map<Integer, Integer> oldToNewReferencesLookup) {
        for (Map.Entry<Integer, Integer> me : this._slideLocations.entrySet()) {
            Integer oldPos = me.getValue();
            Integer newPos = oldToNewReferencesLookup.get(oldPos);
            if (newPos == null) {
                Integer id = me.getKey();
                logger.log(5, "Couldn't find the new location of the \"slide\" with id " + id + " that used to be at " + oldPos);
                logger.log(5, "Not updating the position of it, you probably won't be able to find it any more (if you ever could!)");
                continue;
            }
            me.setValue(newPos);
        }
    }

    private void normalizePersistDirectory() {
        TreeMap<Integer, Integer> orderedSlideLocations = new TreeMap<Integer, Integer>(this._slideLocations);
        BufAccessBAOS bos = new BufAccessBAOS();
        byte[] intbuf = new byte[4];
        int lastPersistEntry = -1;
        int lastSlideId = -1;
        for (Map.Entry<Integer, Integer> me : orderedSlideLocations.entrySet()) {
            int nextSlideId = me.getKey();
            int offset = me.getValue();
            try {
                int infoBlock;
                if (lastSlideId + 1 == nextSlideId) {
                    assert (lastPersistEntry != -1);
                    infoBlock = LittleEndian.getInt(bos.getBuf(), lastPersistEntry);
                    int entryCnt = cntPersistFld.getValue(infoBlock);
                    infoBlock = cntPersistFld.setValue(infoBlock, entryCnt + 1);
                    LittleEndian.putInt(bos.getBuf(), lastPersistEntry, infoBlock);
                } else {
                    lastPersistEntry = bos.size();
                    infoBlock = persistIdFld.setValue(0, nextSlideId);
                    infoBlock = cntPersistFld.setValue(infoBlock, 1);
                    LittleEndian.putInt(intbuf, 0, infoBlock);
                    bos.write(intbuf);
                }
                LittleEndian.putInt(intbuf, 0, offset);
                bos.write(intbuf);
                lastSlideId = nextSlideId;
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
        }
        this._ptrData = bos.toByteArray();
        LittleEndian.putInt(this._header, 4, bos.size());
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.normalizePersistDirectory();
        out.write(this._header);
        out.write(this._ptrData);
    }

    private static class BufAccessBAOS
    extends ByteArrayOutputStream {
        private BufAccessBAOS() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

