/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.util.Collection;
import org.eclipse.equinox.internal.p2.metadata.expression.Binary;
import org.eclipse.equinox.internal.p2.metadata.expression.CoercingComparator;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;

final class Equals
extends Binary {
    final boolean negate;

    Equals(Expression lhs, Expression rhs, boolean negate) {
        super(lhs, rhs);
        this.negate = negate;
    }

    @Override
    public Object evaluate(IEvaluationContext context) {
        Object lhsVal = this.lhs.evaluate(context);
        Object rhsVal = this.rhs.evaluate(context);
        if (lhsVal instanceof Collection) {
            for (Object lhsItem : (Collection)lhsVal) {
                boolean eq = CoercingComparator.coerceAndEquals(lhsItem, rhsVal);
                if (!eq || this.negate) continue;
                return true;
            }
            return this.negate;
        }
        boolean eq = CoercingComparator.coerceAndEquals(lhsVal, rhsVal);
        return this.negate ? !eq : eq;
    }

    @Override
    public int getExpressionType() {
        return this.negate ? 15 : 4;
    }

    @Override
    public String getOperator() {
        return this.negate ? "!=" : "==";
    }

    @Override
    public void toLDAPString(StringBuffer buf) {
        if (this.negate) {
            buf.append("(!");
        }
        buf.append('(');
        this.appendLDAPAttribute(buf);
        buf.append('=');
        this.appendLDAPValue(buf);
        buf.append(')');
        if (this.negate) {
            buf.append(')');
        }
    }
}

