/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.ui.contentassist;

import com.google.common.base.Objects;
import java.net.URL;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.ui.contentassist.AbstractBehaviorProposalProvider;
import org.eclipse.comma.behavior.ui.contentassist.HtmlConfigurableCompletionProposal;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignaturePackage;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class BehaviorProposalProvider
extends AbstractBehaviorProposalProvider {
    protected Image templateIcon = ImageDescriptor.createFromURL((URL)Platform.getBundle((String)"org.eclipse.comma.icons").getResource("icons/template.png")).createImage();
    private final int TEMPLATE_DEFAULT_PRIORITY = 600;
    private final int TEMPLATE_HIGH_PRIORITY = 700;
    private final int TEMPLATE_LOW_PRIORITY = 599;
    public static String STATEMACHINE_TITLE = "StateMachine";
    private static String STATEMACHINE_INFO = "The state machine is a model that can be in exactly one of a number of states";
    public static String STATE_TITLE = "State definition";
    private static String STATE_INFO = "The state is an unique configuration of information in the state machine";
    public static String INITIAL_STATE_TITLE = "Initial state";
    private static String INITIAL_STATE_INFO = "The initial state is the default starting state of the state machine";
    public static String IN_ALL_STATES_TITLE = "In all states";
    private static String IN_ALL_STATES_INFO = "\"in all states\" contains the transitions that are defined in every state.";
    public static String IN_ALL_STATES_EXCEPT_TITLE = "In all states except";
    private static String IN_ALL_STATES_EXCEPT_INFO = "\"in all states except\" contains the transitions that are defined in every state except in the provided states.";
    public static String TRANSITION_TITLE = "Transition definition";
    private static String TRANSITION_INFO = "The transition describes when and how to go to the next state.";
    public static String TRANSITION_GUARD_TITLE = "Transition with guard";
    private static String TRANSITION_GUARD_INFO = "Transitions may have a guard expressed as a boolean expression. Transition is performed if the guard evaluates to true";
    public static String TRANSITION_TRIGGER_TITLE = "Transition trigger";
    private static String TRANSITION_TRIGGER_INFO = "Transitions may be triggered by a call to a command or a signal.";
    public static String TRANSITION_TRIGGER_GUARD_TITLE = "Transition trigger guard";
    private static String TRANSITION_TRIGGER_GUARD_INFO = "Transitions may be triggered by an interface event (command, signal, notification) and may have a guard that is a precondition for the transition";
    private static String NOTIFICATION_INFO = "Available notification from the imported signature.";
    private static String TIME_C_ID = "TimeConstraint";
    private static String DATA_C_ID = "DataConstraint";
    private static String GENERIC_C_ID = "GenericConstraint";
    public static final String INITIAL_STATE_PROPOSAL = new Functions.Function0<String>(){

        public String apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("initial state NewState {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("transition");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("next state: NewState");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            return _builder.toString();
        }
    }.apply();

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int selection, int length) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, 600, selection, length);
    }

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, 600, -1, -1);
    }

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int priority) {
        return this.createTemplate(name, content, additionalInfo, nrIndents, context, priority, -1, -1);
    }

    protected HtmlConfigurableCompletionProposal createTemplate(String name, String content, String additionalInfo, Integer nrIndents, ContentAssistContext context, int priority, int selection, int length) {
        HtmlConfigurableCompletionProposal _xifexpression = null;
        if (nrIndents == 0) {
            _xifexpression = this.createProposal(name, content, additionalInfo, context, priority, selection, length);
        } else {
            HtmlConfigurableCompletionProposal _xblockexpression = null;
            String indent = "";
            int i = 0;
            while (i < nrIndents) {
                String _indent = indent;
                indent = String.valueOf(_indent) + "\t";
                ++i;
            }
            String indentedContent = content.replace("\n", "\n" + indent);
            indentedContent = "\n" + indent + indentedContent;
            _xifexpression = _xblockexpression = this.createProposal(name, indentedContent, additionalInfo, context, priority, selection, length);
        }
        return _xifexpression;
    }

    private HtmlConfigurableCompletionProposal createProposal(String name, String content, String additionalInfo, ContentAssistContext context, int priority, int selection, int length) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        String finalAdditionalInfo = content;
        StyledString _styledString = new StyledString(name);
        HtmlConfigurableCompletionProposal proposal = this.createHtmlCompletionProposal(content, _styledString, this.templateIcon, 600, context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            while (finalAdditionalInfo.startsWith("\n") || finalAdditionalInfo.startsWith("\r")) {
                finalAdditionalInfo = finalAdditionalInfo.substring(1);
            }
            finalAdditionalInfo = "<html><body bgcolor=\"#FFFFE1\"><style> body { font-size:9pt; font-family:'Segoe UI' }</style><pre>" + finalAdditionalInfo + "</pre>";
            if (additionalInfo != null) {
                finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "<p>" + additionalInfo + "</p>";
            }
            finalAdditionalInfo = String.valueOf(finalAdditionalInfo) + "</body></html>";
            proposal.setAdditionalProposalInfo(finalAdditionalInfo);
            proposal.setProposalContextResource((Resource)context.getResource());
            proposal.setPriority(priority);
            int _offset = context.getOffset();
            int _plus = _offset + selection;
            proposal.setSelectionStart(_plus);
            proposal.setSelectionLength(length);
        }
        _xblockexpression = proposal;
        return _xblockexpression;
    }

    private HtmlConfigurableCompletionProposal createHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        boolean _isValidProposal = this.isValidProposal(proposal, context.getPrefix(), context);
        if (_isValidProposal) {
            return this.doCreateHtmlCompletionProposal(proposal, displayString, image, priority, context);
        }
        return null;
    }

    private HtmlConfigurableCompletionProposal doCreateHtmlCompletionProposal(String proposal, StyledString displayString, Image image, int priority, ContentAssistContext context) {
        HtmlConfigurableCompletionProposal _xblockexpression = null;
        int replacementOffset = context.getReplaceRegion().getOffset();
        int replacementLength = context.getReplaceRegion().getLength();
        int _length = proposal.length();
        HtmlConfigurableCompletionProposal result = new HtmlConfigurableCompletionProposal(proposal, replacementOffset, replacementLength, _length, image, displayString, null, null);
        result.setPriority(priority);
        result.setMatcher(context.getMatcher());
        result.setReplaceContextLength(context.getReplaceContextLength());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public void completeExpressionEnumLiteral_Interface(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeExpressionEnumLiteral_Interface(model, assignment, context, acceptor);
        EnumTypeDecl type = this.getEnumType(model);
        if (type != null) {
            Signature signature = (Signature)EcoreUtil2.getContainerOfType((EObject)type, Signature.class);
            EList _literals = type.getLiterals();
            for (EnumElement literals : _literals) {
                String _name = signature.getName();
                String _plus = String.valueOf(_name) + "::";
                String _name_1 = type.getName();
                String _plus_1 = String.valueOf(_plus) + _name_1;
                String _plus_2 = String.valueOf(_plus_1) + "::";
                String _name_2 = literals.getName();
                String _plus_3 = String.valueOf(_plus_2) + _name_2;
                acceptor.accept(this.createDescriptionProposal(_plus_3, (EObject)literals, context));
            }
        }
    }

    public void completeExpressionEnumLiteral_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeExpressionEnumLiteral_Type(model, assignment, context, acceptor);
        INode _currentNode = context.getCurrentNode();
        INode _previousSibling = null;
        if (_currentNode != null) {
            _previousSibling = _currentNode.getPreviousSibling();
        }
        INode _previousSibling_1 = null;
        if (_previousSibling != null) {
            _previousSibling_1 = _previousSibling.getPreviousSibling();
        }
        String _text = null;
        if (_previousSibling_1 != null) {
            _text = _previousSibling_1.getText();
        }
        String previous = _text;
        EnumTypeDecl type = this.getEnumType(model);
        if (type != null && previous != null) {
            String _xifexpression = null;
            boolean _equals = previous.equals(type.getName());
            if (_equals) {
                _xifexpression = "";
            } else {
                String _name = type.getName();
                _xifexpression = String.valueOf(_name) + "::";
            }
            String prefix = _xifexpression;
            EList _literals = type.getLiterals();
            for (EnumElement literals : _literals) {
                String _name_1 = literals.getName();
                String _plus = String.valueOf(prefix) + _name_1;
                acceptor.accept(this.createDescriptionProposal(_plus, (EObject)literals, context));
            }
        }
    }

    public EnumTypeDecl getEnumType(EObject model) {
        TypeDecl dType;
        InterfaceEvent _trigger_1;
        Type type;
        TriggeredTransition transition;
        InterfaceEvent _trigger;
        if (model instanceof CommandReply && (_trigger = (transition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)model, TriggeredTransition.class)).getTrigger()) instanceof Command && (type = ((Command)(_trigger_1 = transition.getTrigger())).getType()) instanceof TypeReference && (dType = ((TypeReference)type).getType()) instanceof EnumTypeDecl) {
            return (EnumTypeDecl)dType;
        }
        return null;
    }

    public ICompletionProposal createDescriptionProposal(String proposalString, EObject obj, ContentAssistContext context) {
        StyledString _styledString = new StyledString(proposalString);
        ICompletionProposal proposal = this.createCompletionProposal(proposalString, _styledString, null, 500, context.getPrefix(), context);
        if (proposal instanceof ConfigurableCompletionProposal) {
            ((ConfigurableCompletionProposal)proposal).setAdditionalProposalInfo((Object)obj);
            ((ConfigurableCompletionProposal)proposal).setHover(this.getHover());
            ((ConfigurableCompletionProposal)proposal).setProposalContextResource((Resource)context.getResource());
        }
        return proposal;
    }

    @Override
    public void complete_StateMachine(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_StateMachine(model, ruleCall, context, acceptor);
        this.addStatemachineTemplate(context, acceptor);
    }

    public void addStatemachineTemplate(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String id = "StateMachine";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("machine ");
        _builder.append("StateMachine");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("initial state initialState {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(STATEMACHINE_TITLE, prop, STATEMACHINE_INFO, 0, context, 8, "StateMachine".length()));
    }

    @Override
    public void completeStateMachine_States(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeStateMachine_States(model, assignment, context, acceptor);
        this.addInitialState(model, context, acceptor);
        this.addState(model, context, acceptor);
    }

    public void addState(EObject object, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String id = "NewState";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("state ");
        _builder.append("NewState");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("transition");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("next state: NewState");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(STATE_TITLE, proposal, STATE_INFO, 1, context, 6, "NewState".length()));
    }

    public void addInitialState(EObject object, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _statemachinContainsInitialState;
        if (object instanceof StateMachine && (_statemachinContainsInitialState = this.statemachinContainsInitialState((StateMachine)object))) {
            acceptor.accept((ICompletionProposal)this.createTemplate(INITIAL_STATE_TITLE, INITIAL_STATE_PROPOSAL, INITIAL_STATE_INFO, 1, context));
        }
    }

    @Override
    public void complete_InAllStatesBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        boolean _not;
        super.complete_InAllStatesBlock(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("in all states {");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(IN_ALL_STATES_TITLE, proposal, IN_ALL_STATES_INFO, 1, context));
        IScope states = this.scopeProvider.getScope(model, BehaviorPackage.Literals.STATE_MACHINE__STATES);
        String except = "state1";
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)states.getAllElements());
        boolean bl = _not = !_isEmpty;
        if (_not) {
            except = ((IEObjectDescription[])Conversions.unwrapArray((Object)states.getAllElements(), IEObjectDescription.class))[0].getName().getLastSegment();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("in all states except ");
        _builder_1.append(except);
        _builder_1.append(" {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        String exceptProposal = _builder_1.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(IN_ALL_STATES_EXCEPT_TITLE, exceptProposal, IN_ALL_STATES_EXCEPT_INFO, 1, context, 23, except.length()));
    }

    @Override
    public void completeState_Transitions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeState_Transitions(model, assignment, context, acceptor);
        String nextState = "NextState";
        if (model instanceof State) {
            nextState = ((State)model).getName();
        }
        this.addTransition(model, nextState, context, acceptor);
        this.addTransitionTrigger(model, nextState, context, acceptor);
        this.addTransitionGuard(model, nextState, context, acceptor);
        this.addTransitionTriggerGuard(model, nextState, context, acceptor);
    }

    @Override
    public void complete_Transition(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_Transition(model, ruleCall, context, acceptor);
        String nextState = "NextState";
        this.addTransition(model, nextState, context, acceptor);
        this.addTransitionTrigger(model, nextState, context, acceptor);
        this.addTransitionGuard(model, nextState, context, acceptor);
        this.addTransitionTriggerGuard(model, nextState, context, acceptor);
    }

    public void addTransitionTrigger(EObject object, String nextState, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String id = "interfaceEvent";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transition trigger: ");
        _builder.append("interfaceEvent");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("do: reply(*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next state: ");
        _builder.append(nextState, "\t");
        _builder.newLineIfNotEmpty();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(TRANSITION_TRIGGER_TITLE, proposal, TRANSITION_TRIGGER_INFO, 2, context, 20, "interfaceEvent".length()));
    }

    public void addTransitionGuard(EObject object, String nextState, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String guard = "true";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transition guard: ");
        _builder.append("true");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("next state: ");
        _builder.append(nextState, "\t");
        _builder.newLineIfNotEmpty();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(TRANSITION_GUARD_TITLE, proposal, TRANSITION_GUARD_INFO, 2, context, 18, "true".length()));
    }

    public void addTransitionTriggerGuard(EObject object, String nextState, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String id = "interfaceEvent";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transition trigger: ");
        _builder.append("interfaceEvent");
        _builder.append(" guard: true");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("do: reply(*)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next state: ");
        _builder.append(nextState, "\t");
        _builder.newLineIfNotEmpty();
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(TRANSITION_TRIGGER_GUARD_TITLE, proposal, TRANSITION_TRIGGER_GUARD_INFO, 2, context, 599, 20, "interfaceEvent".length()));
    }

    public void addTransition(EObject object, String nextState, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("transition");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("next state: ");
        _builder.append(nextState, "\t");
        String proposal = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate(TRANSITION_TITLE, proposal, TRANSITION_INFO, 2, context, 700));
    }

    private boolean statemachinContainsInitialState(StateMachine machine) {
        boolean _equals;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)machine.getStates(), (Functions.Function1)_function));
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return true;
        }
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)machine.getStates(), (Functions.Function1)_function_1));
        return _size_1 > 1;
    }

    @Override
    public void completeClause_Actions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeClause_Actions(model, assignment, context, acceptor);
        Iterable signatures = this.scopeProvider.getScope(model, InterfaceSignaturePackage.Literals.INTERFACE_SIGNATURE_DEFINITION__SIGNATURE).getAllElements();
        for (IEObjectDescription signatureDescription : signatures) {
            EObject object = signatureDescription.getEObjectOrProxy();
            EObject _xifexpression = null;
            boolean _eIsProxy = object.eIsProxy();
            _xifexpression = _eIsProxy ? EcoreUtil2.resolve((EObject)object, (EObject)model) : object;
            Signature signature = (Signature)_xifexpression;
            EList _notifications = signature.getNotifications();
            for (Notification notification : _notifications) {
                boolean _not;
                EList parameters = notification.getParameters();
                String title = null;
                String proposal = null;
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)parameters);
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    String _name = notification.getName();
                    _builder.append(_name);
                    _builder.append("(");
                    for (Parameter param : parameters) {
                        boolean _tripleNotEquals;
                        String _paramTypeToString = this.paramTypeToString(param);
                        _builder.append(_paramTypeToString);
                        Parameter _last = (Parameter)IterableExtensions.last((Iterable)parameters);
                        boolean bl2 = _tripleNotEquals = _last != param;
                        if (!_tripleNotEquals) continue;
                        _builder.append(", ");
                    }
                    _builder.append(")");
                    title = _builder.toString();
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_1 = notification.getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("(");
                    for (Parameter param_1 : parameters) {
                        boolean _tripleNotEquals_1;
                        String _paramToString = this.paramToString(param_1);
                        _builder_1.append(_paramToString);
                        Parameter _last_1 = (Parameter)IterableExtensions.last((Iterable)parameters);
                        boolean bl3 = _tripleNotEquals_1 = _last_1 != param_1;
                        if (!_tripleNotEquals_1) continue;
                        _builder_1.append(", ");
                    }
                    _builder_1.append(")");
                    proposal = _builder_1.toString();
                } else {
                    title = notification.getName();
                    proposal = notification.getName();
                }
                acceptor.accept((ICompletionProposal)this.createProposal(title, proposal, NOTIFICATION_INFO, context, 700, -1, -1));
            }
        }
    }

    public String paramTypeToString(Parameter param) {
        Type type = param.getType();
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            return typeDecl.getName();
        }
        return "param";
    }

    public String paramToString(Parameter param) {
        Type type = param.getType();
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            if (typeDecl instanceof SimpleTypeDecl) {
                String _name = ((SimpleTypeDecl)typeDecl).getName();
                boolean _matched = false;
                if (Objects.equal((Object)_name, (Object)"int")) {
                    _matched = true;
                    return "0";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"any")) {
                    _matched = true;
                    return "1";
                }
                if (!_matched && Objects.equal((Object)_name, (Object)"string")) {
                    _matched = true;
                    return "\"value\"";
                }
                return ((SimpleTypeDecl)typeDecl).getName();
            }
            if (typeDecl instanceof EnumTypeDecl) {
                EObject _eContainer = ((EnumTypeDecl)typeDecl).eContainer();
                String _name_1 = ((Signature)_eContainer).getName();
                String _plus = String.valueOf(_name_1) + "::";
                String _name_2 = ((EnumTypeDecl)typeDecl).getName();
                String _plus_1 = String.valueOf(_plus) + _name_2;
                String _plus_2 = String.valueOf(_plus_1) + "::";
                String _name_3 = ((EnumElement)((EnumTypeDecl)typeDecl).getLiterals().get(0)).getName();
                return String.valueOf(_plus_2) + _name_3;
            }
            if (typeDecl instanceof VectorTypeDecl) {
                return "[0]";
            }
            if (typeDecl instanceof RecordTypeDecl) {
                return "[0]";
            }
            return typeDecl.getName();
        }
        return "param";
    }

    @Override
    public void complete_TimeConstraintsBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TimeConstraintsBlock(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("timing constraints");
        _builder.newLine();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Timing constraints", prop, "", 0, context));
    }

    @Override
    public void complete_GenericConstraintsBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_GenericConstraintsBlock(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("generic constraints");
        _builder.newLine();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generic constraints", prop, "", 0, context));
    }

    @Override
    public void complete_DataConstraintsBlock(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DataConstraintsBlock(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("data constraints");
        _builder.newLine();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Data constraints", prop, "", 0, context));
    }

    @Override
    public void complete_TimeConstraint(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_TimeConstraint(model, ruleCall, context, acceptor);
        this.acceptTimeConstraintExample(model, ruleCall, context, acceptor);
        this.acceptTimeConstraintInterval(model, ruleCall, context, acceptor);
        this.acceptTimeConstraintConditioned(model, ruleCall, context, acceptor);
        this.acceptTimeConstraintAbsence(model, ruleCall, context, acceptor);
        this.acceptTimeConstraintPeriodic(model, ruleCall, context, acceptor);
    }

    public void acceptTimeConstraintPeriodic(EObject object, RuleCall call, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(TIME_C_ID);
        _builder.append(" reply(*) to command Command then notification Notification with period 2000.0 ms jitter 10.0 ms until signal Signal");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Time Constraint Periodic", prop, "Example of a periodic time constraint.", 0, context, 0, TIME_C_ID.length()));
    }

    public void acceptTimeConstraintAbsence(EObject object, RuleCall call, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(TIME_C_ID);
        _builder.append(" signal Signal -> absent in state State signal Signal2 in [.. 5000.0 ms]");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Time Constraint Absence", prop, "Example of an Absence and Conditioned time constraint.", 0, context, 0, TIME_C_ID.length()));
    }

    public void acceptTimeConstraintConditioned(EObject object, RuleCall call, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(TIME_C_ID);
        _builder.append(" in state State command Command - [ 1.0 ms .. 100.0 ms ] -> reply(*)");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Time Constraint Conditioned", prop, "Example of a Conditioned time constraint.", 0, context, 0, TIME_C_ID.length()));
    }

    public void acceptTimeConstraintInterval(EObject object, RuleCall call, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(TIME_C_ID);
        _builder.append(" Command and Command2 -> [.. 100.0 ms] between events");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Time Constraint Interval", prop, "Example of an Interval time constraint.", 0, context, 0, TIME_C_ID.length()));
    }

    public void acceptTimeConstraintExample(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(TIME_C_ID);
        _builder.append(" any command - [ 1.0 ms .. 10.0 ms ] -> reply");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Time Constraint Simple", prop, "Example of a Simple time constraint.", 0, context, 0, TIME_C_ID.length()));
    }

    @Override
    public void complete_DataConstraint(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_DataConstraint(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(DATA_C_ID);
        _builder.append(" any command until any signal where var < 1");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Data Constraint Simple", prop, "Example of a Simple data constraint.", 0, context, 0, DATA_C_ID.length()));
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append(DATA_C_ID);
        _builder_1.append(" command Command until Signal signal where var < 1");
        _builder_1.newLineIfNotEmpty();
        String prop2 = _builder_1.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Data Constraint Until", prop2, "Example of a Until data constraint.", 0, context, 0, DATA_C_ID.length()));
    }

    @Override
    public void complete_GenericConstraint(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_GenericConstraint(model, ruleCall, context, acceptor);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(GENERIC_C_ID);
        _builder.append(" <var, any event> until <var, reply>");
        _builder.newLineIfNotEmpty();
        String prop = _builder.toString();
        acceptor.accept((ICompletionProposal)this.createTemplate("Generic Constraint example", prop, "Generic constraint example", 0, context, GENERIC_C_ID.length()));
    }
}

