/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import org.eclipse.comma.monitoring.lib.constraints.CSimpleTimeRule;
import org.eclipse.comma.monitoring.lib.messages.CEnvironment;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.values.CInterval;

public class CSimpleTimeRuleEnvironment
extends CEnvironment {
    private double t1;
    private double t2;
    private double t3;
    private CInterval i;
    private double intervalEnd;
    private CSimpleTimeRule rule;

    public CSimpleTimeRuleEnvironment setInterval(CInterval newInterval) {
        this.i = newInterval;
        return this;
    }

    public CInterval getInterval() {
        return this.i;
    }

    public CSimpleTimeRuleEnvironment setIntervalEnd(double iEnd) {
        this.intervalEnd = iEnd;
        return this;
    }

    @Override
    public CEnvironment setVariableValue(String name, Object value) {
        if (name.equals("t1")) {
            this.t1 = (Double)value;
        }
        if (name.equals("t2")) {
            this.t2 = (Double)value;
        }
        if (name.equals("t3")) {
            this.t3 = (Double)value;
        }
        return this;
    }

    public void setRule(CSimpleTimeRule r) {
        this.rule = r;
    }

    @Override
    public boolean checkCondition(int index, CObservedMessage message) {
        switch (index) {
            case 1: {
                this.rule.notifyOnIntervalCheck(this.t3 - this.t1);
                return this.i.isIn(this.t3 - this.t1);
            }
            case 2: {
                if (this.intervalEnd == -1.0) {
                    return true;
                }
                return this.t2 - this.t1 <= this.intervalEnd;
            }
        }
        return false;
    }
}

