/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.history;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.ui.PageCompareEditorInput;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;

public class HistoryPageCompareEditorInput
extends PageCompareEditorInput {
    private IHistoryPage historyPage;
    private DialogHistoryPageSite site;
    private final Object object;
    private final IHistoryPageSource pageSource;
    private final IPropertyChangeListener changeListener = this::handlePropertyChange;
    private boolean isReplace;

    public HistoryPageCompareEditorInput(CompareConfiguration configuration, IHistoryPageSource pageSource, Object object) {
        super(configuration);
        this.pageSource = pageSource;
        this.object = object;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return this.object;
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        if (this.historyPage != null) {
            this.historyPage.removePropertyChangeListener(this.changeListener);
            this.historyPage.dispose();
        }
    }

    @Override
    protected IPage createPage(CompareViewerPane parent, IToolBarManager toolBarManager) {
        this.site = new DialogHistoryPageSite(parent.getShell());
        this.historyPage = (IHistoryPage)this.pageSource.createPage(this.object);
        this.historyPage.setSite(this.site);
        this.site.setToolBarManager(toolBarManager);
        ((Page)this.historyPage).createControl((Composite)parent);
        this.historyPage.setInput(this.object);
        String description = this.historyPage.getDescription();
        if (description == null) {
            description = "";
        }
        this.setPageDescription(description);
        if (this.getTitle() == null) {
            this.setTitle(this.historyPage.getName());
        }
        this.historyPage.addPropertyChangeListener(this.changeListener);
        return (IPage)this.historyPage;
    }

    @Override
    protected ICompareInput asCompareInput(ISelection selection) {
        IStructuredSelection ss;
        ICompareInput compareInput = super.asCompareInput(selection);
        if (compareInput != null) {
            return compareInput;
        }
        IHistoryCompareAdapter compareAdapter = (IHistoryCompareAdapter)Adapters.adapt((Object)this.historyPage, IHistoryCompareAdapter.class);
        if (compareAdapter != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
            Object o = ss.getFirstElement();
            return compareAdapter.getCompareInput(o);
        }
        return null;
    }

    @Override
    protected ISelectionProvider getSelectionProvider() {
        return this.site.getSelectionProvider();
    }

    @Override
    protected void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) throws InvocationTargetException {
        IHistoryCompareAdapter compareAdapter = (IHistoryCompareAdapter)Adapters.adapt((Object)this.historyPage, IHistoryCompareAdapter.class);
        if (compareAdapter != null) {
            compareAdapter.prepareInput(input, configuration, monitor);
        }
    }

    public final IHistoryPage getHistoryPage() {
        return this.historyPage;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.historyPage) {
            if (event.getProperty().equals("org.eclipse.team.ui.name")) {
                Display.getDefault().asyncExec(() -> this.setTitle(this.historyPage.getName()));
            } else if (event.getProperty().equals("org.eclipse.team.ui.description")) {
                Display.getDefault().asyncExec(() -> this.setPageDescription(this.historyPage.getDescription()));
            }
        }
    }

    public boolean isEditionSelectionDialog() {
        return this.isReplaceDialog();
    }

    protected boolean isReplaceDialog() {
        return this.isReplace;
    }

    public void setReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public String getOKButtonLabel() {
        if (this.isReplaceDialog()) {
            return TeamUIMessages.HistoryPageCompareEditorInput_0;
        }
        return super.getOKButtonLabel();
    }

    public boolean okPressed() {
        if (!this.isReplaceDialog()) {
            return super.okPressed();
        }
        try {
            Object o = this.getSelectedEdition();
            this.performReplace(((ICompareInput)o).getRight());
        }
        catch (CoreException e) {
            Utils.handle(e);
            return false;
        }
        return true;
    }

    protected void performReplace(Object selectedObject) throws CoreException {
    }
}

