/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.utilities;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.types.types.ModelContainer;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CommaUtilities {
    public static final String NAMESPACE_SEPARATOR = ".";
    @Inject
    private ResourceDescriptionsProvider rdp;
    @Inject
    private IContainer.Manager cm;

    public static <T extends EObject> List<T> resolveProxy(EObject context, Iterable<IEObjectDescription> elements) {
        ArrayList<EObject> _xblockexpression = null;
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (IEObjectDescription descr : elements) {
            EObject object = descr.getEObjectOrProxy();
            boolean _eIsProxy = object.eIsProxy();
            if (_eIsProxy) {
                object = EcoreUtil2.resolve((EObject)object, (EObject)context);
            }
            result.add(object);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static QualifiedName getNamespace(EObject o) {
        QualifiedName _xblockexpression = null;
        QualifiedName result = QualifiedName.EMPTY;
        Iterable containers = EcoreUtil2.getAllContainers((EObject)o);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)containers);
        if (_isEmpty) {
            return result;
        }
        EObject top = (EObject)IterableExtensions.last((Iterable)containers);
        if (top instanceof ModelContainer) {
            boolean _tripleNotEquals;
            String _name = ((ModelContainer)top).getName();
            boolean bl = _tripleNotEquals = _name != null;
            if (_tripleNotEquals) {
                String[] _split;
                String[] stringArray = _split = ((ModelContainer)top).getName().split("\\.");
                int n = _split.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    result = result.append(segment.replace("^", ""));
                    ++n2;
                }
            }
        }
        List _reverseView = ListExtensions.reverseView((List)IterableExtensions.toList((Iterable)Iterables.filter((Iterable)containers, NamedElement.class)));
        for (NamedElement container : _reverseView) {
            result = result.append(container.getName().replace("^", ""));
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getNamespaceAsString(EObject o) {
        return CommaUtilities.getNamespace(o).toString(NAMESPACE_SEPARATOR);
    }

    public static QualifiedName getFullyQualifiedName(NamedElement o) {
        return CommaUtilities.getNamespace(o).append(o.getName().replace("^", ""));
    }

    public static String getFullyQualifiedNameAsString(NamedElement o) {
        return CommaUtilities.getFullyQualifiedName(o).toString(NAMESPACE_SEPARATOR);
    }

    public List<IContainer> getVisibleContainers(EObject o) {
        List _xblockexpression = null;
        IResourceDescriptions index = this.rdp.getResourceDescriptions(o.eResource());
        IResourceDescription rd = index.getResourceDescription(o.eResource().getURI());
        _xblockexpression = this.cm.getVisibleContainers(rd, index);
        return _xblockexpression;
    }

    public Iterable<IEObjectDescription> getVisibleEObjectDescriptions(EObject o, final EClass type) {
        Functions.Function1<IContainer, Iterable<IEObjectDescription>> _function = new Functions.Function1<IContainer, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IContainer container) {
                return container.getExportedObjectsByType(type);
            }
        };
        return Iterables.concat((Iterable)ListExtensions.map(this.getVisibleContainers(o), (Functions.Function1)_function));
    }

    public IResourceDescription getResourceDescription(EObject o) {
        return this.getResourceDescription(o.eResource());
    }

    public IResourceDescription getResourceDescription(Resource r) {
        IResourceDescription _xblockexpression = null;
        IResourceDescriptions index = this.rdp.getResourceDescriptions(r);
        _xblockexpression = index.getResourceDescription(r.getURI());
        return _xblockexpression;
    }

    public Iterable<IEObjectDescription> getExportedEObjectDescriptions(EObject o) {
        return this.getResourceDescription(o).getExportedObjects();
    }

    public static String commaVersion() {
        return "2.0.0";
    }
}

