/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.imagecontrol.jface;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuSupport {
    private Collection<Action> menuActions = new ArrayList<Action>();
    private Listener menuDetectListener = new Listener(){

        public void handleEvent(Event event) {
            Control control = (Control)event.widget;
            Menu menu = control.getMenu();
            if (menu != null) {
                menu.dispose();
            }
            menu = new Menu(control.getDisplay().getFocusControl());
            for (final Action action : MenuSupport.this.menuActions) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText(action.getText());
                item.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        action.run();
                    }
                });
            }
            control.setMenu(menu);
        }
    };

    public void addImageControl(Control control) {
        control.addListener(35, this.menuDetectListener);
    }

    public void removeImageControl(Control control) {
        control.removeListener(35, this.menuDetectListener);
    }

    public void addMenuAction(Action action) {
        this.menuActions.add(action);
    }

    public void removeMenuAction(Action action) {
        this.menuActions.remove(action);
    }
}

