/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.scr.impl.metadata.DSVersion;
import org.apache.felix.scr.impl.metadata.MetadataStoreHelper;
import org.apache.felix.scr.impl.metadata.PropertyMetadata;
import org.apache.felix.scr.impl.metadata.ReferenceMetadata;
import org.apache.felix.scr.impl.metadata.ServiceMetadata;
import org.apache.felix.scr.impl.metadata.TargetedPID;
import org.osgi.service.component.ComponentException;

public class ComponentMetadata {
    public static final String CONFIGURATION_POLICY_REQUIRE = "require";
    public static final String CONFIGURATION_POLICY_IGNORE = "ignore";
    public static final String CONFIGURATION_POLICY_OPTIONAL = "optional";
    private static final Set<String> CONFIGURATION_POLICY_VALID;
    private static final String IMPLEMENTATION_CLASS_DUPLICATE = "icd";
    private static final ServiceMetadata SERVICE_DUPLICATE;
    private final DSVersion m_dsVersion;
    private String m_name;
    private boolean m_enabled = true;
    private String m_factory;
    private Boolean m_immediate;
    private String m_implementationClassName;
    private String m_activate;
    private boolean m_activateDeclared = false;
    private String m_deactivate;
    private boolean m_deactivateDeclared = false;
    private String m_modified;
    private String m_configurationPolicy;
    private List<String> m_configurationPid;
    private List<String> m_activationFields;
    private final Map<String, Object> m_properties = new HashMap<String, Object>();
    private final Map<String, Object> m_factoryProperties = new HashMap<String, Object>();
    private final List<PropertyMetadata> m_propertyMetaData = new ArrayList<PropertyMetadata>();
    private final List<PropertyMetadata> m_factoryPropertyMetaData = new ArrayList<PropertyMetadata>();
    private ServiceMetadata m_service;
    private final List<ReferenceMetadata> m_references = new ArrayList<ReferenceMetadata>();
    private boolean m_configurableServiceProperties;
    private boolean m_persistentFactoryComponent;
    private boolean m_deleteCallsModify;
    private Boolean m_obsoleteFactoryComponentFactory;
    private boolean m_configureWithInterfaces;
    private boolean m_delayedKeepInstances;
    private String m_init;
    private boolean m_validated = false;
    private static final byte TypeString = 1;
    private static final byte TypeLong = 2;
    private static final byte TypeDouble = 3;
    private static final byte TypeFloat = 4;
    private static final byte TypeInteger = 5;
    private static final byte TypeByte = 6;
    private static final byte TypeChar = 7;
    private static final byte TypeBoolean = 8;
    private static final byte TypeShort = 9;

    public ComponentMetadata(DSVersion dsVersion) {
        this.m_dsVersion = dsVersion;
    }

    public void setConfigurationPid(String[] configurationPid) {
        if (this.m_validated) {
            return;
        }
        this.m_configurationPid = new ArrayList<String>(Arrays.asList(configurationPid));
    }

    public void setName(String name) {
        if (this.m_validated) {
            return;
        }
        this.m_name = name;
    }

    public void setEnabled(boolean enabled) {
        if (this.m_validated) {
            return;
        }
        this.m_enabled = enabled;
    }

    public void setFactoryIdentifier(String factoryIdentifier) {
        if (this.m_validated) {
            return;
        }
        this.m_factory = factoryIdentifier;
    }

    public void setImmediate(boolean immediate) {
        if (this.m_validated) {
            return;
        }
        this.m_immediate = immediate ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setImplementationClassName(String implementationClassName) {
        if (this.m_validated) {
            return;
        }
        this.m_implementationClassName = this.m_implementationClassName != null ? IMPLEMENTATION_CLASS_DUPLICATE : implementationClassName;
    }

    public void setConfigurationPolicy(String configurationPolicy) {
        if (this.m_validated) {
            return;
        }
        this.m_configurationPolicy = configurationPolicy;
    }

    public void setActivate(String activate) {
        if (this.m_validated) {
            return;
        }
        this.m_activate = activate;
        this.m_activateDeclared = true;
    }

    public void setDeactivate(String deactivate) {
        if (this.m_validated) {
            return;
        }
        this.m_deactivate = deactivate;
        this.m_deactivateDeclared = true;
    }

    public void setModified(String modified) {
        if (this.m_validated) {
            return;
        }
        this.m_modified = modified;
    }

    public void addProperty(PropertyMetadata newProperty) {
        if (this.m_validated) {
            return;
        }
        if (newProperty == null) {
            throw new IllegalArgumentException("Cannot add a null property");
        }
        this.m_propertyMetaData.add(newProperty);
    }

    public void addFactoryProperty(PropertyMetadata newProperty) {
        if (this.m_validated) {
            return;
        }
        if (newProperty == null) {
            throw new IllegalArgumentException("Cannot add a null property");
        }
        this.m_factoryPropertyMetaData.add(newProperty);
    }

    public void setService(ServiceMetadata service) {
        if (this.m_validated) {
            return;
        }
        this.m_service = this.m_service != null ? SERVICE_DUPLICATE : service;
    }

    public void addDependency(ReferenceMetadata newReference) {
        if (this.m_validated) {
            return;
        }
        if (newReference == null) {
            throw new IllegalArgumentException("Cannot add a null ReferenceMetadata");
        }
        this.m_references.add(newReference);
    }

    public void setConfigurableServiceProperties(boolean configurableServiceProperties) {
        if (this.m_validated) {
            return;
        }
        this.m_configurableServiceProperties = configurableServiceProperties;
    }

    public void setPersistentFactoryComponent(boolean persistentFactoryComponent) {
        if (this.m_validated) {
            return;
        }
        this.m_persistentFactoryComponent = persistentFactoryComponent;
    }

    public void setDeleteCallsModify(boolean deleteCallsModify) {
        if (this.m_validated) {
            return;
        }
        this.m_deleteCallsModify = deleteCallsModify;
    }

    public void setObsoleteFactoryComponentFactory(boolean obsoleteFactoryComponentFactory) {
        if (this.m_validated) {
            return;
        }
        this.m_obsoleteFactoryComponentFactory = obsoleteFactoryComponentFactory;
    }

    public void setConfigureWithInterfaces(boolean configureWithInterfaces) {
        this.m_configureWithInterfaces = configureWithInterfaces;
    }

    public void setDelayedKeepInstances(boolean delayedKeepInstances) {
        if (this.m_validated) {
            return;
        }
        this.m_delayedKeepInstances = delayedKeepInstances;
    }

    public void setActivationFields(String[] fields) {
        if (!this.m_validated) {
            this.m_activationFields = new ArrayList<String>(Arrays.asList(fields));
        }
    }

    public void setInit(String value) {
        if (!this.m_validated) {
            this.m_init = value;
        }
    }

    public DSVersion getDSVersion() {
        return this.m_dsVersion;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return this.getImplementationClassName();
    }

    public List<String> getConfigurationPid() {
        if (!this.m_validated) {
            throw new IllegalStateException("not yet validated");
        }
        return this.m_configurationPid;
    }

    public int getPidIndex(TargetedPID pid) {
        if (!this.m_validated) {
            throw new IllegalStateException("not yet validated");
        }
        if (this.m_configurationPid == null) {
            throw new IllegalStateException("Apparently trying to configure a component " + this.m_name + " without a configurationPid using " + pid);
        }
        return this.m_configurationPid.indexOf(pid.getServicePid());
    }

    public boolean isConfigurationPidDeclared() {
        return this.m_configurationPid != null;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public String getFactoryIdentifier() {
        return this.m_factory;
    }

    public boolean isImmediate() {
        if (this.m_immediate != null) {
            return this.m_immediate;
        }
        return this.m_service == null && this.m_factory == null;
    }

    public String getImplementationClassName() {
        return this.m_implementationClassName;
    }

    public String getConfigurationPolicy() {
        return this.m_configurationPolicy;
    }

    public String getActivate() {
        return this.m_activate;
    }

    public boolean isActivateDeclared() {
        return this.m_activateDeclared;
    }

    public int getNumberOfConstructorParameters() {
        return this.m_init == null ? 0 : Integer.valueOf(this.m_init);
    }

    public List<String> getActivationFields() {
        return this.m_activationFields;
    }

    public String getDeactivate() {
        return this.m_deactivate;
    }

    public boolean isDeactivateDeclared() {
        return this.m_deactivateDeclared;
    }

    public String getModified() {
        return this.m_modified;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.m_service;
    }

    public ServiceMetadata.Scope getServiceScope() {
        if (this.m_service == null) {
            return ServiceMetadata.Scope.singleton;
        }
        return this.m_service.getScope();
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    public Map<String, Object> getFactoryProperties() {
        return this.m_factoryProperties;
    }

    List<PropertyMetadata> getPropertyMetaData() {
        return this.m_propertyMetaData;
    }

    List<PropertyMetadata> getFactoryPropertyMetaData() {
        return this.m_factoryPropertyMetaData;
    }

    public List<ReferenceMetadata> getDependencies() {
        return this.m_references;
    }

    public boolean isFactory() {
        return this.m_factory != null;
    }

    public boolean isConfigurationRequired() {
        return CONFIGURATION_POLICY_REQUIRE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationIgnored() {
        return CONFIGURATION_POLICY_IGNORE.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurationOptional() {
        return CONFIGURATION_POLICY_OPTIONAL.equals(this.m_configurationPolicy);
    }

    public boolean isConfigurableServiceProperties() {
        return this.m_configurableServiceProperties;
    }

    public boolean isPersistentFactoryComponent() {
        return this.m_persistentFactoryComponent;
    }

    public boolean isDeleteCallsModify() {
        return this.m_deleteCallsModify;
    }

    public boolean isObsoleteFactoryComponentFactory() {
        return this.m_obsoleteFactoryComponentFactory == null ? false : this.m_obsoleteFactoryComponentFactory;
    }

    public boolean isConfigureWithInterfaces() {
        return this.m_configureWithInterfaces;
    }

    public boolean isDelayedKeepInstances() {
        return this.m_delayedKeepInstances;
    }

    public void validate() {
        if (this.m_validated) {
            return;
        }
        if (this.m_name == null) {
            if (!this.m_dsVersion.isDS11()) {
                throw new ComponentException("The component name has not been set");
            }
            this.setName(this.getImplementationClassName());
        }
        if (this.m_implementationClassName == null) {
            throw this.validationFailure("Implementation class name missing");
        }
        if (this.m_implementationClassName == IMPLEMENTATION_CLASS_DUPLICATE) {
            throw this.validationFailure("Implementation element must occur exactly once");
        }
        if (this.m_configurationPolicy == null) {
            this.m_configurationPolicy = CONFIGURATION_POLICY_OPTIONAL;
        } else {
            if (!this.m_dsVersion.isDS11()) {
                throw this.validationFailure("configuration-policy declaration requires DS 1.1 or later namespace ");
            }
            if (!CONFIGURATION_POLICY_VALID.contains(this.m_configurationPolicy)) {
                throw this.validationFailure("configuration-policy must be one of " + CONFIGURATION_POLICY_VALID);
            }
        }
        if (this.m_activate == null) {
            this.m_activate = "activate";
        } else if (!this.m_dsVersion.isDS11()) {
            throw this.validationFailure("activate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_deactivate == null) {
            this.m_deactivate = "deactivate";
        } else if (!this.m_dsVersion.isDS11()) {
            throw this.validationFailure("deactivate method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_modified != null && !this.m_dsVersion.isDS11()) {
            throw this.validationFailure("modified method declaration requires DS 1.1 or later namespace ");
        }
        if (this.m_configurationPid == null) {
            this.m_configurationPid = Collections.singletonList(this.getName());
        } else {
            if (!this.m_dsVersion.isDS12()) {
                throw this.validationFailure("configuration-pid attribute requires DS 1.2 or later namespace ");
            }
            if (this.m_configurationPid.isEmpty()) {
                throw this.validationFailure("configuration-pid nust not be empty string ");
            }
            if (this.m_configurationPid.size() > 1 && !this.m_dsVersion.isDS13()) {
                throw this.validationFailure("multiple configuration-pid requires DS 1.3 or later namespace ");
            }
            for (int i = 0; i < this.m_configurationPid.size(); ++i) {
                if (!"$".equals(this.m_configurationPid.get(i))) continue;
                if (!this.m_dsVersion.isDS13()) {
                    throw this.validationFailure("Use of '$' configuration-pid wildcard requires DS 1.3 or later namespace ");
                }
                this.m_configurationPid.set(i, this.getName());
            }
            if (new HashSet<String>(this.m_configurationPid).size() != this.m_configurationPid.size()) {
                throw this.validationFailure("Duplicate pids not allowed: " + this.m_configurationPid);
            }
        }
        for (PropertyMetadata propertyMetadata : this.m_propertyMetaData) {
            propertyMetadata.validate(this);
            this.m_properties.put(propertyMetadata.getName(), propertyMetadata.getValue());
        }
        this.m_propertyMetaData.clear();
        if (!this.m_dsVersion.isDS14() && !this.m_factoryPropertyMetaData.isEmpty()) {
            throw this.validationFailure("Use of factory properties requires DS 1.4 or later namespace ");
        }
        if (this.m_dsVersion.isDS14() && this.isFactory()) {
            for (PropertyMetadata propertyMetadata : this.m_factoryPropertyMetaData) {
                propertyMetadata.validate(this);
                this.m_factoryProperties.put(propertyMetadata.getName(), propertyMetadata.getValue());
            }
        }
        this.m_factoryPropertyMetaData.clear();
        if (this.m_service == SERVICE_DUPLICATE) {
            throw this.validationFailure("Service element must occur at most once");
        }
        if (this.m_service != null) {
            this.m_service.validate(this);
        }
        HashSet<String> refs = new HashSet<String>();
        for (ReferenceMetadata refMeta : this.m_references) {
            refMeta.validate(this);
            if (refs.add(refMeta.getName())) continue;
            throw this.validationFailure("Detected duplicate reference name: ''" + refMeta.getName() + "''");
        }
        if (this.m_immediate != null) {
            if (this.isImmediate()) {
                if (this.isFactory()) {
                    throw this.validationFailure("Factory cannot be immediate");
                }
            } else if (this.m_service == null && !this.isFactory()) {
                throw this.validationFailure("Delayed must provide a service or be a factory");
            }
        }
        if (this.m_service != null && this.m_service.getScope() != ServiceMetadata.Scope.singleton && (this.isFactory() || this.isImmediate())) {
            throw this.validationFailure("factory or immediate must be scope singleton not " + (Object)((Object)this.m_service.getScope()));
        }
        if (this.m_activationFields != null && !this.m_dsVersion.isDS14()) {
            throw this.validationFailure("Activation fields require version 1.4 or later");
        }
        if (this.m_init != null) {
            if (!this.m_dsVersion.isDS14()) {
                throw this.validationFailure("Constructor injection requires version 1.4 or later");
            }
            boolean bl = false;
            try {
                int n = Integer.valueOf(this.m_init);
                if (n < 0) {
                    throw this.validationFailure("Init parameter must have non negative value: " + this.m_init);
                }
            }
            catch (NumberFormatException nfe) {
                throw this.validationFailure("Init parameter is not a number: " + this.m_init);
            }
        }
        if (this.m_dsVersion == DSVersion.DS12Felix) {
            this.m_configurableServiceProperties = true;
        }
        if (this.m_configurableServiceProperties && this.getServiceScope() != ServiceMetadata.Scope.singleton) {
            throw this.validationFailure("configurable service properties only allowed with singleton scope");
        }
        if (this.m_dsVersion.isDS13()) {
            this.m_deleteCallsModify = true;
        }
        if (!this.m_dsVersion.isDS13() && this.m_configureWithInterfaces) {
            throw this.validationFailure("Configuration with interfaces or annotations only possible with version 1.3 or later");
        }
        if (this.m_dsVersion.isDS13() && this.m_obsoleteFactoryComponentFactory != null) {
            throw this.validationFailure("Configuration of component factory instances through config admin factory pids supported only through the 1.2 namespace");
        }
        if (this.m_persistentFactoryComponent && !this.isFactory()) {
            throw this.validationFailure("Only a factory component can be a persistent factory component");
        }
        this.m_validated = true;
    }

    ComponentException validationFailure(String reason) {
        return new ComponentException("Component " + this.getName() + " validation failed: " + reason);
    }

    public void collectStrings(Set<String> strings) {
        MetadataStoreHelper.addString(this.m_dsVersion.toString(), strings);
        MetadataStoreHelper.addString(this.m_activate, strings);
        if (this.m_activationFields != null) {
            for (String string : this.m_activationFields) {
                MetadataStoreHelper.addString(string, strings);
            }
        }
        if (this.m_configurationPid != null) {
            for (String string : this.m_configurationPid) {
                MetadataStoreHelper.addString(string, strings);
            }
        }
        MetadataStoreHelper.addString(this.m_configurationPolicy, strings);
        MetadataStoreHelper.addString(this.m_deactivate, strings);
        MetadataStoreHelper.addString(this.m_factory, strings);
        MetadataStoreHelper.addString(this.m_implementationClassName, strings);
        MetadataStoreHelper.addString(this.m_init, strings);
        MetadataStoreHelper.addString(this.m_modified, strings);
        MetadataStoreHelper.addString(this.m_name, strings);
        for (Map.Entry entry : this.m_factoryProperties.entrySet()) {
            this.collectStrings(entry, strings);
        }
        for (Map.Entry entry : this.m_properties.entrySet()) {
            this.collectStrings(entry, strings);
        }
        for (ReferenceMetadata referenceMetadata : this.m_references) {
            referenceMetadata.collectStrings(strings);
        }
        if (this.m_service != null) {
            this.m_service.collectStrings(strings);
        }
    }

    private void collectStrings(Map.Entry<String, Object> entry, Set<String> strings) {
        MetadataStoreHelper.addString(entry.getKey(), strings);
        Object v = entry.getValue();
        if (v instanceof String) {
            MetadataStoreHelper.addString((String)v, strings);
        } else if (v instanceof String[]) {
            for (String s : (String[])v) {
                MetadataStoreHelper.addString(s, strings);
            }
        }
    }

    public void store(DataOutputStream out, MetadataStoreHelper.MetaDataWriter metaDataWriter) throws IOException {
        metaDataWriter.writeString(this.m_dsVersion.toString(), out);
        metaDataWriter.writeString(this.m_activate, out);
        out.writeBoolean(this.m_activationFields != null);
        if (this.m_activationFields != null) {
            out.writeInt(this.m_activationFields.size());
            for (String string : this.m_activationFields) {
                metaDataWriter.writeString(string, out);
            }
        }
        out.writeBoolean(this.m_configurationPid != null);
        if (this.m_configurationPid != null) {
            out.writeInt(this.m_configurationPid.size());
            for (String string : this.m_configurationPid) {
                metaDataWriter.writeString(string, out);
            }
        }
        metaDataWriter.writeString(this.m_configurationPolicy, out);
        metaDataWriter.writeString(this.m_deactivate, out);
        metaDataWriter.writeString(this.m_factory, out);
        metaDataWriter.writeString(this.m_implementationClassName, out);
        metaDataWriter.writeString(this.m_init, out);
        metaDataWriter.writeString(this.m_modified, out);
        metaDataWriter.writeString(this.m_name, out);
        out.writeInt(this.m_factoryProperties.size());
        for (Map.Entry entry : this.m_factoryProperties.entrySet()) {
            metaDataWriter.writeString((String)entry.getKey(), out);
            this.storePropertyValue(entry.getValue(), out, metaDataWriter);
        }
        out.writeInt(this.m_properties.size());
        for (Map.Entry entry : this.m_properties.entrySet()) {
            metaDataWriter.writeString((String)entry.getKey(), out);
            this.storePropertyValue(entry.getValue(), out, metaDataWriter);
        }
        out.writeInt(this.m_references.size());
        for (ReferenceMetadata referenceMetadata : this.m_references) {
            referenceMetadata.store(out, metaDataWriter);
        }
        out.writeBoolean(this.m_service != null);
        if (this.m_service != null) {
            this.m_service.store(out, metaDataWriter);
        }
        out.writeBoolean(this.m_activateDeclared);
        out.writeBoolean(this.m_configurableServiceProperties);
        out.writeBoolean(this.m_configureWithInterfaces);
        out.writeBoolean(this.m_deactivateDeclared);
        out.writeBoolean(this.m_delayedKeepInstances);
        out.writeBoolean(this.m_deleteCallsModify);
        out.writeBoolean(this.m_enabled);
        out.writeBoolean(this.m_immediate != null);
        if (this.m_immediate != null) {
            out.writeBoolean(this.m_immediate);
        }
    }

    public static ComponentMetadata load(DataInputStream in, MetadataStoreHelper.MetaDataReader metaDataReader) throws IOException {
        int i;
        int size;
        ComponentMetadata result = new ComponentMetadata(DSVersion.valueOf(metaDataReader.readString(in)));
        result.m_activate = metaDataReader.readString(in);
        if (in.readBoolean()) {
            size = in.readInt();
            String[] activationFields = new String[size];
            for (i = 0; i < size; ++i) {
                activationFields[i] = metaDataReader.readString(in);
            }
            result.setActivationFields(activationFields);
        }
        if (in.readBoolean()) {
            size = in.readInt();
            String[] configPids = new String[size];
            for (i = 0; i < size; ++i) {
                configPids[i] = metaDataReader.readString(in);
            }
            result.setConfigurationPid(configPids);
        }
        result.m_configurationPolicy = metaDataReader.readString(in);
        result.m_deactivate = metaDataReader.readString(in);
        result.m_factory = metaDataReader.readString(in);
        result.m_implementationClassName = metaDataReader.readString(in);
        result.m_init = metaDataReader.readString(in);
        result.m_modified = metaDataReader.readString(in);
        result.m_name = metaDataReader.readString(in);
        int numFProps = in.readInt();
        for (int i2 = 0; i2 < numFProps; ++i2) {
            result.m_factoryProperties.put(metaDataReader.readString(in), ComponentMetadata.loadPropertyValue(in, metaDataReader));
        }
        int numProps = in.readInt();
        for (i = 0; i < numProps; ++i) {
            result.m_properties.put(metaDataReader.readString(in), ComponentMetadata.loadPropertyValue(in, metaDataReader));
        }
        int numRefs = in.readInt();
        for (int i3 = 0; i3 < numRefs; ++i3) {
            result.addDependency(ReferenceMetadata.load(in, metaDataReader));
        }
        if (in.readBoolean()) {
            result.m_service = ServiceMetadata.load(in, metaDataReader);
        }
        result.m_activateDeclared = in.readBoolean();
        result.m_configurableServiceProperties = in.readBoolean();
        result.m_configureWithInterfaces = in.readBoolean();
        result.m_deactivateDeclared = in.readBoolean();
        result.m_delayedKeepInstances = in.readBoolean();
        result.m_deleteCallsModify = in.readBoolean();
        result.m_enabled = in.readBoolean();
        if (in.readBoolean()) {
            result.m_immediate = in.readBoolean();
        }
        result.m_validated = true;
        return result;
    }

    static Object loadPropertyValue(DataInputStream in, MetadataStoreHelper.MetaDataReader metaDataReader) throws IOException {
        boolean isArray = in.readBoolean();
        byte valueType = in.readByte();
        switch (valueType) {
            case 8: {
                if (isArray) {
                    boolean[] vArray = new boolean[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readBoolean();
                    }
                    return vArray;
                }
                return in.readBoolean();
            }
            case 6: {
                if (isArray) {
                    byte[] vArray = new byte[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readByte();
                    }
                    return vArray;
                }
                return in.readByte();
            }
            case 7: {
                if (isArray) {
                    char[] vArray = new char[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readChar();
                    }
                    return vArray;
                }
                return Character.valueOf(in.readChar());
            }
            case 3: {
                if (isArray) {
                    double[] vArray = new double[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readDouble();
                    }
                    return vArray;
                }
                return in.readDouble();
            }
            case 4: {
                if (isArray) {
                    float[] vArray = new float[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readFloat();
                    }
                    return vArray;
                }
                return Float.valueOf(in.readFloat());
            }
            case 5: {
                if (isArray) {
                    int[] vArray = new int[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readInt();
                    }
                    return vArray;
                }
                return in.readInt();
            }
            case 2: {
                if (isArray) {
                    long[] vArray = new long[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readLong();
                    }
                    return vArray;
                }
                return in.readLong();
            }
            case 9: {
                if (isArray) {
                    short[] vArray = new short[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = in.readShort();
                    }
                    return vArray;
                }
                return in.readShort();
            }
            case 1: {
                if (isArray) {
                    String[] vArray = new String[in.readInt()];
                    for (int i = 0; i < vArray.length; ++i) {
                        vArray[i] = metaDataReader.readString(in);
                    }
                    return vArray;
                }
                return metaDataReader.readString(in);
            }
        }
        return null;
    }

    void storePropertyValue(Object value, DataOutputStream out, MetadataStoreHelper.MetaDataWriter metaDataWriter) throws IOException {
        if (value == null) {
            out.writeBoolean(false);
            out.writeByte(1);
            metaDataWriter.writeString(null, out);
            return;
        }
        Class<?> arrayType = value.getClass().getComponentType();
        boolean isArray = arrayType != null;
        out.writeBoolean(isArray);
        byte valueType = this.getType(arrayType == null ? value.getClass() : arrayType);
        out.writeByte(valueType);
        switch (valueType) {
            case 8: {
                if (isArray) {
                    boolean[] vArray = (boolean[])value;
                    out.writeInt(vArray.length);
                    for (boolean v : vArray) {
                        out.writeBoolean(v);
                    }
                    break;
                }
                out.writeBoolean((Boolean)value);
                break;
            }
            case 6: {
                if (isArray) {
                    byte[] vArray = (byte[])value;
                    out.writeInt(vArray.length);
                    for (byte v : vArray) {
                        out.writeByte(v);
                    }
                    break;
                }
                out.writeByte(((Byte)value).byteValue());
                break;
            }
            case 7: {
                if (isArray) {
                    char[] vArray = (char[])value;
                    out.writeInt(vArray.length);
                    for (char v : vArray) {
                        out.writeChar(v);
                    }
                    break;
                }
                out.writeChar(((Character)value).charValue());
                break;
            }
            case 3: {
                if (isArray) {
                    double[] vArray = (double[])value;
                    out.writeInt(vArray.length);
                    for (double v : vArray) {
                        out.writeDouble(v);
                    }
                    break;
                }
                out.writeDouble((Double)value);
                break;
            }
            case 4: {
                if (isArray) {
                    float[] vArray = (float[])value;
                    out.writeInt(vArray.length);
                    for (float v : vArray) {
                        out.writeFloat(v);
                    }
                    break;
                }
                out.writeFloat(((Float)value).floatValue());
                break;
            }
            case 5: {
                if (isArray) {
                    int[] vArray = (int[])value;
                    out.writeInt(vArray.length);
                    for (int v : vArray) {
                        out.writeInt(v);
                    }
                    break;
                }
                out.writeInt((Integer)value);
                break;
            }
            case 2: {
                if (isArray) {
                    long[] vArray = (long[])value;
                    out.writeInt(vArray.length);
                    for (long v : vArray) {
                        out.writeLong(v);
                    }
                    break;
                }
                out.writeLong((Long)value);
                break;
            }
            case 9: {
                if (isArray) {
                    short[] vArray = (short[])value;
                    out.writeInt(vArray.length);
                    for (short v : vArray) {
                        out.writeShort(v);
                    }
                    break;
                }
                out.writeShort(((Short)value).shortValue());
                break;
            }
            case 1: {
                if (isArray) {
                    String[] vArray = (String[])value;
                    out.writeInt(vArray.length);
                    for (String v : vArray) {
                        metaDataWriter.writeString(v, out);
                    }
                    break;
                }
                metaDataWriter.writeString((String)value, out);
            }
        }
    }

    private byte getType(Class<?> typeClass) {
        if (Boolean.class.equals(typeClass) || Boolean.TYPE.equals(typeClass)) {
            return 8;
        }
        if (Byte.class.equals(typeClass) || Byte.TYPE.equals(typeClass)) {
            return 6;
        }
        if (Character.class.equals(typeClass) || Character.TYPE.equals(typeClass)) {
            return 7;
        }
        if (Double.class.equals(typeClass) || Double.TYPE.equals(typeClass)) {
            return 3;
        }
        if (Float.class.equals(typeClass) || Float.TYPE.equals(typeClass)) {
            return 4;
        }
        if (Integer.class.equals(typeClass) || Integer.TYPE.equals(typeClass)) {
            return 5;
        }
        if (Long.class.equals(typeClass) || Long.TYPE.equals(typeClass)) {
            return 2;
        }
        if (Short.class.equals(typeClass) || Short.TYPE.equals(typeClass)) {
            return 9;
        }
        if (String.class.equals(typeClass)) {
            return 1;
        }
        throw new IllegalArgumentException("Unsupported type: " + typeClass);
    }

    static {
        SERVICE_DUPLICATE = new ServiceMetadata();
        CONFIGURATION_POLICY_VALID = new TreeSet<String>();
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_IGNORE);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_OPTIONAL);
        CONFIGURATION_POLICY_VALID.add(CONFIGURATION_POLICY_REQUIRE);
    }
}

