/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.behavior;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConnectorOperator implements Enumerator
{
    U(0, "U", "until"),
    WU(1, "WU", "wuntil");

    public static final int U_VALUE = 0;
    public static final int WU_VALUE = 1;
    private static final ConnectorOperator[] VALUES_ARRAY;
    public static final List<ConnectorOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConnectorOperator[]{U, WU};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConnectorOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectorOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectorOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConnectorOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConnectorOperator get(int value) {
        switch (value) {
            case 0: {
                return U;
            }
            case 1: {
                return WU;
            }
        }
        return null;
    }

    private ConnectorOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

