/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.services.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.tools.services.IResourceProviderService;
import org.eclipse.e4.tools.services.IResourceService;
import org.eclipse.e4.tools.services.impl.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ResourceService
implements IResourceService {
    private final Map<Display, DisplayPool> displayPool = new HashMap<Display, DisplayPool>();
    private final BundleContext context;

    public ResourceService() {
        Bundle b = FrameworkUtil.getBundle(ResourceService.class);
        this.context = b.getBundleContext();
    }

    protected void removePooledResource(PooledResource<?> resource) {
        if (resource.getResource() instanceof Image) {
            this.displayPool.get(resource.display).getImagePool().remove(resource.getId());
        } else if (resource.getResource() instanceof Color) {
            this.displayPool.get(resource.display).getColorPool().remove(resource.getId());
        } else if (resource.getResource() instanceof Font) {
            this.displayPool.get(resource.display).getFontPool().remove(resource.getId());
        }
    }

    private <R extends Resource> PooledResource<R> loadResource(Display display, String key, Type type) {
        DisplayPool p = this.displayPool.get(display);
        PooledResource<Object> resource = null;
        if (p != null) {
            resource = type == Type.IMAGE ? p.getImagePool().get(key) : (type == Type.COLOR ? p.getColorPool().get(key) : p.getFontPool().get(key));
        }
        if (resource != null && resource.getResource() != null) {
            ++resource.count;
        } else {
            resource = new PooledResource<Resource>(display, this, key, (Resource)this.lookupResource(display, key, type));
            if (p == null) {
                p = new DisplayPool();
                this.displayPool.put(display, p);
            }
            if (type == Type.IMAGE) {
                p.getImagePool().put(key, resource);
            } else if (type == Type.COLOR) {
                p.getColorPool().put(key, resource);
            } else {
                p.getFontPool().put(key, resource);
            }
        }
        return resource;
    }

    private <R> R lookupResource(Display display, String key, Type type) {
        if (type == Type.IMAGE) {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getImage(display, key);
            }
        } else if (type == Type.COLOR) {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getColor(display, key);
            }
        } else {
            IResourceProviderService provider = this.lookupOSGI(key);
            if (provider != null) {
                return (R)provider.getFont(display, key);
            }
        }
        throw new IllegalArgumentException(String.valueOf(Messages.ResourceService_NoProvider) + key + "'.");
    }

    private IResourceProviderService lookupOSGI(String key) {
        try {
            Collection refs = this.context.getServiceReferences(IResourceProviderService.class, "(" + key + "=*)");
            if (!refs.isEmpty()) {
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                return (IResourceProviderService)this.context.getService(ref);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public PooledResource<Image> getImage(Display display, String key) {
        return this.loadResource(display, key, Type.IMAGE);
    }

    public PooledResource<Color> getColor(Display display, String key) {
        return this.loadResource(display, key, Type.COLOR);
    }

    public PooledResource<Font> getFont(Display display, String key) {
        return this.loadResource(display, key, Type.FONT);
    }

    @Override
    public IResourceService.IDiposeableResourcePool getResourcePool(Display display) {
        return new ResourcePool(this, display);
    }

    @Override
    public IResourcePool getControlPool(Control control) {
        ResourcePool pool = new ResourcePool(this, control.getDisplay());
        control.addDisposeListener(e -> pool.dispose());
        return pool;
    }

    static class DisplayPool {
        private Map<String, PooledResource<Image>> imagePool;
        private Map<String, PooledResource<Color>> colorPool;
        private Map<String, PooledResource<Font>> fontPool;

        DisplayPool() {
        }

        public Map<String, PooledResource<Color>> getColorPool() {
            if (this.colorPool == null) {
                this.colorPool = new HashMap<String, PooledResource<Color>>();
            }
            return this.colorPool;
        }

        public Map<String, PooledResource<Image>> getImagePool() {
            if (this.imagePool == null) {
                this.imagePool = new HashMap<String, PooledResource<Image>>();
            }
            return this.imagePool;
        }

        public Map<String, PooledResource<Font>> getFontPool() {
            if (this.fontPool == null) {
                this.fontPool = new HashMap<String, PooledResource<Font>>();
            }
            return this.fontPool;
        }
    }

    static class PooledResource<T extends Resource>
    implements IResourceService.IPooledResource<T> {
        private final Display display;
        private int count;
        private T resource;
        private String id;
        private ResourceService resourceService;

        PooledResource(Display display, ResourceService resourceService, String id, T resource) {
            this.display = display;
            this.id = id;
            this.count = 1;
            this.resourceService = resourceService;
            this.resource = resource;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public T getResource() {
            return this.resource;
        }

        @Override
        public void dispose() {
            --this.count;
            if (this.count == 0) {
                this.resourceService.removePooledResource(this);
                if (this.resource != null) {
                    this.resource.dispose();
                }
                this.resource = null;
                this.id = null;
                this.resourceService = null;
            }
        }
    }

    public static class ResourcePool
    implements IResourceService.IDiposeableResourcePool {
        private IResourceService resourceService;
        private List<IResourceService.IPooledResource<Image>> pooledImages = new ArrayList<IResourceService.IPooledResource<Image>>();
        private List<IResourceService.IPooledResource<Font>> pooledFonts = new ArrayList<IResourceService.IPooledResource<Font>>();
        private List<IResourceService.IPooledResource<Color>> pooledColors = new ArrayList<IResourceService.IPooledResource<Color>>();
        private final Display display;

        @Inject
        public ResourcePool(IResourceService resourceService, Display display) {
            this.display = display;
            this.resourceService = resourceService;
        }

        @Override
        public Image getImage(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", Messages.ResourceService_PoolDisposed));
            }
            IResourceService.IPooledResource<Image> image = null;
            for (IResourceService.IPooledResource<Image> img : this.pooledImages) {
                if (!img.getId().equals(key)) continue;
                image = img;
            }
            if (image == null) {
                image = this.resourceService.getImage(this.display, key);
                this.pooledImages.add(image);
            }
            return (Image)image.getResource();
        }

        @Override
        public Font getFont(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", Messages.ResourceService_PoolDisposed));
            }
            IResourceService.IPooledResource<Font> font = null;
            for (IResourceService.IPooledResource<Font> fon : this.pooledFonts) {
                if (!fon.getId().equals(key)) continue;
                font = fon;
            }
            if (font == null) {
                font = this.resourceService.getFont(this.display, key);
                this.pooledFonts.add(font);
            }
            return (Font)font.getResource();
        }

        @Override
        public Color getColor(String key) throws CoreException {
            if (this.resourceService == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.e4.tools.services", Messages.ResourceService_PoolDisposed));
            }
            IResourceService.IPooledResource<Color> color = null;
            for (IResourceService.IPooledResource<Color> col : this.pooledColors) {
                if (!col.getId().equals(key)) continue;
                color = col;
            }
            if (color == null) {
                color = this.resourceService.getColor(this.display, key);
                this.pooledColors.add(color);
            }
            return (Color)color.getResource();
        }

        @Override
        public Image getImageUnchecked(String key) {
            try {
                return this.getImage(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        @Override
        public Font getFontUnchecked(String key) {
            try {
                return this.getFont(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        @Override
        public Color getColorUnchecked(String key) {
            try {
                return this.getColor(key);
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        @Override
        @PreDestroy
        public void dispose() {
            for (IResourceService.IPooledResource<Image> iPooledResource : this.pooledImages) {
                iPooledResource.dispose();
            }
            for (IResourceService.IPooledResource<Image> iPooledResource : this.pooledFonts) {
                iPooledResource.dispose();
            }
            for (IResourceService.IPooledResource<Image> iPooledResource : this.pooledColors) {
                iPooledResource.dispose();
            }
            this.resourceService = null;
            this.pooledImages = null;
            this.pooledFonts = null;
            this.pooledColors = null;
        }
    }

    private static enum Type {
        IMAGE,
        FONT,
        COLOR;

    }
}

