/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.jsp.jasper;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.jsp.jasper.Activator;
import org.eclipse.equinox.internal.jsp.jasper.BundleProxyClassLoader;
import org.eclipse.equinox.internal.jsp.jasper.JSPContextFinder;
import org.osgi.framework.Bundle;

public class JspClassLoader
extends URLClassLoader {
    private static final Bundle JASPERBUNDLE = Activator.getJasperBundle();
    private static final ClassLoader PARENT = JspClassLoader.class.getClassLoader().getParent();
    private static final String JAVA_PACKAGE = "java.";
    private static final ClassLoader EMPTY_CLASSLOADER = new ClassLoader(){

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> findResources(String name) {
            return Collections.emptyEnumeration();
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }
    };

    public JspClassLoader(Bundle bundle) {
        super(new URL[0], (ClassLoader)new BundleProxyClassLoader(bundle, (ClassLoader)new BundleProxyClassLoader(JASPERBUNDLE, (ClassLoader)new JSPContextFinder(EMPTY_CLASSLOADER))));
        this.addBundleClassPathJars(bundle);
        Bundle[] fragments = Activator.getFragments(bundle);
        if (fragments != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                this.addBundleClassPathJars(fragment);
                ++n2;
            }
        }
    }

    private void addBundleClassPathJars(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String classPath = (String)headers.get("Bundle-ClassPath");
        if (classPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",");
            while (tokenizer.hasMoreTokens()) {
                URL entry;
                String candidate = tokenizer.nextToken().trim();
                if (!candidate.endsWith(".jar") || (entry = bundle.getEntry(candidate)) == null) continue;
                try {
                    URL jarEntryURL = new URL("jar:" + entry.toString() + "!/");
                    super.addURL(jarEntryURL);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PARENT != null && name.startsWith(JAVA_PACKAGE)) {
            return PARENT.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }
}

