/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormFilteredTree
extends FilteredTree {
    private FormToolkit toolkit;
    private FormEntry fEntryFilter;

    public FormFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter, true);
    }

    protected void createControl(Composite parent, int treeStyle) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = FormLayoutFactory.createClearGridLayout(false, 1);
        layout.verticalSpacing = 3;
        super.createControl(parent, treeStyle);
        this.setLayout((Layout)layout);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected Text doCreateFilterText(Composite parent) {
        int borderStyle = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        Text temp = super.doCreateFilterText(parent);
        int style = temp.getStyle();
        temp.dispose();
        this.fEntryFilter = new FormEntry(parent, this.toolkit, null, style);
        this.toolkit.setBorderStyle(borderStyle);
        this.setBackground(this.toolkit.getColors().getBackground());
        return this.fEntryFilter.getText();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer = super.doCreateTreeViewer(parent, this.toolkit.getBorderStyle() | style);
        this.toolkit.paintBordersFor(viewer.getTree().getParent());
        return viewer;
    }

    public void createUIListenerEntryFilter(IContextPart part) {
        this.fEntryFilter.setFormEntryListener(new FormEntryAdapter(part){

            @Override
            public void browseButtonSelected(FormEntry entry) {
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
            }

            @Override
            public void linkEntered(HyperlinkEvent e) {
            }

            @Override
            public void linkExited(HyperlinkEvent e) {
            }

            @Override
            public void selectionChanged(FormEntry entry) {
            }

            @Override
            public void textDirty(FormEntry entry) {
            }

            @Override
            public void textValueChanged(FormEntry entry) {
            }
        });
    }

    public boolean isFiltered() {
        Text filterText = this.getFilterControl();
        if (filterText != null) {
            String filterString = filterText.getText();
            boolean filtered = filterString != null && filterString.length() > 0 && !filterString.equals(this.getInitialText());
            return filtered;
        }
        return false;
    }
}

