/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.LazyStartHeader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeFieldAssistDisposer;
import org.eclipse.pde.internal.ui.editor.plugin.GeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class PluginGeneralInfoSection
extends GeneralInfoSection {
    private FormEntry fClassEntry;
    private Button fLazyStart;
    private TypeFieldAssistDisposer fTypeFieldAssistDisposer;
    private boolean fBlockListener = false;

    public PluginGeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent);
    }

    @Override
    protected String getSectionDescription() {
        return PDEUIMessages.ManifestEditor_PluginSpecSection_desc;
    }

    @Override
    protected void createSpecificControls(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        this.createClassEntry(parent, toolkit, actionBars);
        FormEditor formEditor = this.getPage().getEditor();
        if (this.isBundle() && formEditor instanceof ManifestEditor) {
            this.createLazyStart(parent, toolkit, actionBars);
            this.createSingleton(parent, toolkit, actionBars, PDEUIMessages.PluginGeneralInfoSection_singleton);
        }
    }

    @Override
    protected void addListeners() {
        IBundleModel model;
        if (this.isBundle() && (model = this.getBundle().getModel()) != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.addListeners();
    }

    @Override
    protected void removeListeners() {
        IBundleModel model;
        if (this.isBundle() && (model = this.getBundle().getModel()) != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.removeListeners();
    }

    private void createLazyStart(Composite parent, FormToolkit toolkit, IActionBars actionBars) {
        this.fLazyStart = toolkit.createButton(parent, PDEUIMessages.PluginGeneralInfoSection_lazyStart, 32);
        TableWrapData td = new TableWrapData();
        td.colspan = 3;
        this.fLazyStart.setLayoutData((Object)td);
        this.fLazyStart.setEnabled(this.isEditable());
        this.fLazyStart.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            LazyStartHeader[] headers = this.getLazyStartHeaders();
            this.fBlockListener = true;
            LazyStartHeader[] lazyStartHeaderArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                LazyStartHeader header = lazyStartHeaderArray[n2];
                header.setLazyStart(this.fLazyStart.getSelection());
                ++n2;
            }
            if (headers.length == 0) {
                this.getBundle().setHeader(this.getLazyStartHeaderName(), this.getLazyStateHeaderValue(this.fLazyStart.getSelection()));
            }
            this.fBlockListener = false;
        }));
    }

    private void createClassEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        boolean isEditable = this.isEditable();
        this.fClassEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_class, PDEUIMessages.GeneralInfoSection_browse, this.isEditable());
        this.fClassEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    ((IPlugin)PluginGeneralInfoSection.this.getPluginBase()).setClassName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            @Override
            public void linkActivated(HyperlinkEvent e) {
                String value = PluginGeneralInfoSection.this.fClassEntry.getValue();
                IProject project = PluginGeneralInfoSection.this.getPage().getPDEEditor().getCommonProject();
                if ((value = PDEJavaHelperUI.createClass(value, project, PluginGeneralInfoSection.this.createJavaAttributeValue(), false)) != null) {
                    PluginGeneralInfoSection.this.fClassEntry.setValue(value);
                }
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                PluginGeneralInfoSection.this.doOpenSelectionDialog(entry.getValue());
            }
        });
        this.fClassEntry.setEditable(isEditable);
        if (isEditable) {
            this.fTypeFieldAssistDisposer = PDEJavaHelperUI.addTypeFieldAssistToText(this.fClassEntry.getText(), this.getProject(), 5);
        }
    }

    private void doOpenSelectionDialog(String className) {
        IResource resource = this.getPluginBase().getModel().getUnderlyingResource();
        String type = PDEJavaHelperUI.selectType(resource, 2, className, null);
        if (type != null) {
            this.fClassEntry.setValue(type);
        }
    }

    private JavaAttributeValue createJavaAttributeValue() {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        return new JavaAttributeValue(project, model, null, this.fClassEntry.getValue());
    }

    @Override
    public void cancelEdit() {
        this.fClassEntry.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public void commit(boolean onSave) {
        this.fClassEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void refresh() {
        if (this.fBlockListener) {
            return;
        }
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model == null) {
            return;
        }
        IPlugin plugin = (IPlugin)model.getPluginBase();
        if (!this.fClassEntry.isDirty()) {
            this.fClassEntry.setValue(plugin.getClassName(), true);
        }
        if (this.fLazyStart != null) {
            IManifestHeader header = this.getLazyStartHeader();
            this.fLazyStart.setSelection(header instanceof LazyStartHeader && ((LazyStartHeader)header).isLazyStart());
        }
        super.refresh();
    }

    private LazyStartHeader[] getLazyStartHeaders() {
        IBundle bundle = this.getBundle();
        ArrayList<IManifestHeader> headers = new ArrayList<IManifestHeader>(3);
        if (bundle instanceof Bundle) {
            String[] keys;
            String[] stringArray = keys = new String[]{"Eclipse-LazyStart", "Eclipse-AutoStart", "Bundle-ActivationPolicy"};
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                IManifestHeader header = bundle.getManifestHeader(key);
                if (header != null) {
                    headers.add(header);
                }
                ++n2;
            }
        }
        return headers.toArray(new LazyStartHeader[headers.size()]);
    }

    private IManifestHeader getLazyStartHeader() {
        IBundle bundle = this.getBundle();
        IManifestHeader header = null;
        if (bundle instanceof Bundle) {
            double targetVersion = TargetPlatformHelper.getTargetVersion();
            if (targetVersion >= 3.3) {
                header = bundle.getManifestHeader("Bundle-ActivationPolicy");
            }
            if (header == null && targetVersion >= 3.2) {
                header = bundle.getManifestHeader("Eclipse-LazyStart");
            }
            if (header == null) {
                header = bundle.getManifestHeader("Eclipse-AutoStart");
            }
        }
        return header;
    }

    private String getLazyStartHeaderName() {
        if (BundlePluginBase.getBundleManifestVersion((IBundle)this.getBundle()) >= 2) {
            if (TargetPlatformHelper.getTargetVersion() >= 3.4) {
                return "Bundle-ActivationPolicy";
            }
            if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
                return "Eclipse-LazyStart";
            }
        }
        return "Eclipse-AutoStart";
    }

    private String getLazyStateHeaderValue(boolean lazyStart) {
        if (BundlePluginBase.getBundleManifestVersion((IBundle)this.getBundle()) >= 2 && TargetPlatformHelper.getTargetVersion() >= 3.4) {
            return lazyStart ? "lazy" : null;
        }
        return Boolean.toString(lazyStart);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fTypeFieldAssistDisposer != null) {
            this.fTypeFieldAssistDisposer.dispose();
        }
    }
}

