/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.ui.launcher.AbstractPDELaunchConfiguration;
import org.osgi.framework.Version;

@Deprecated
public class EclipseApplicationLaunchConfiguration
extends AbstractPDELaunchConfiguration {
    private Map<String, IPluginModelBase> fAllBundles;
    private Map<IPluginModelBase, String> fModels;
    private String fWorkspaceLocation;

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        throw new CoreException(LauncherUtils.createErrorStatus((String)PDEMessages.PDE_updateManagerNotSupported));
    }

    protected File getConfigDir(ILaunchConfiguration config) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)config);
        }
        return this.fConfigDir;
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        if (this.fWorkspaceLocation == null) {
            this.fWorkspaceLocation = LaunchArgumentsHelper.getWorkspaceLocation((ILaunchConfiguration)configuration);
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)this.fWorkspaceLocation, (IProgressMonitor)subMon.split(25));
        subMon.setWorkRemaining(25);
        if (subMon.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (configuration.getAttribute("clearConfig", false)) {
            CoreUtility.deleteContent((File)this.getConfigDir(configuration), (IProgressMonitor)subMon.split(25));
        }
        subMon.done();
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fWorkspaceLocation = null;
        this.fModels = BundleLauncherHelper.getMergedBundleMap((ILaunchConfiguration)configuration, (boolean)false);
        this.fAllBundles = new HashMap<String, IPluginModelBase>(this.fModels.size());
        for (IPluginModelBase model : this.fModels.keySet()) {
            this.fAllBundles.put(model.getPluginBase().getId(), model);
        }
        this.validateConfigIni(configuration);
        super.preLaunchCheck(configuration, launch, monitor);
    }

    private void validateConfigIni(ILaunchConfiguration configuration) throws CoreException {
        if (!configuration.getAttribute("useDefaultConfig", true)) {
            String templateLoc = configuration.getAttribute("templateConfig", "");
            IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
            templateLoc = mgr.performStringSubstitution(templateLoc);
            File templateFile = new File(templateLoc);
            if (!templateFile.exists() && !LauncherUtils.generateConfigIni()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] vmArgs = super.getVMArguments(configuration);
        IPluginModelBase base = this.fAllBundles.get("org.eclipse.pde.core");
        if (base != null && VersionUtil.compareMacroMinorMicro((Version)base.getBundleDescription().getVersion(), (Version)new Version("3.3.1")) >= 0) {
            String[] result = new String[vmArgs.length + 1];
            System.arraycopy(vmArgs, 0, result, 0, vmArgs.length);
            result[vmArgs.length] = "-Declipse.pde.launch=true";
            return result;
        }
        return vmArgs;
    }
}

