/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class FileSystemExporter {
    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++n2;
            }
        }
    }

    protected void writeFile(IFile file, IPath destinationPath) throws IOException {
        Files.copy(file.getLocation().toFile().toPath(), destinationPath.toFile().toPath(), StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

