/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cast
extends Expression {
    private final Identifier type;
    private final Expression target;

    public Cast(Identifier type, Expression target) {
        this.type = type;
        this.target = target;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Identifier getType() {
        return this.type;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        return this.getTarget().evaluate(ctx);
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = this.getTarget().analyze(ctx, issues);
        Type toCast = this.findType(this.getType(), ctx, issues);
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Couldn't find type " + this.getType().toString(), this.getType()));
            return null;
        }
        if (t == null) {
            return null;
        }
        if (t instanceof ParameterizedType && toCast instanceof ParameterizedType) {
            if (t.isAssignableFrom(toCast)) {
                Type innerType = this.getCastedType(((ParameterizedType)t).getInnerType(), ((ParameterizedType)toCast).getInnerType(), ctx.getObjectType());
                if (innerType == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
                    return null;
                }
                return ((ParameterizedType)toCast).cloneWithInnerType(innerType);
            }
            if (toCast.isAssignableFrom(t)) {
                Type innerType = this.getCastedType(((ParameterizedType)t).getInnerType(), ((ParameterizedType)toCast).getInnerType(), ctx.getObjectType());
                if (innerType == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
                    return null;
                }
                return ((ParameterizedType)t).cloneWithInnerType(innerType);
            }
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
            return null;
        }
        Type rt = this.getCastedType(t, toCast, ctx.getObjectType());
        if (rt == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "cannot cast from " + t.toString() + " to " + toCast.toString(), this));
        }
        return rt;
    }

    private Type getCastedType(Type typeA, Type typeB, Type objType) {
        Type _typeB;
        Type _typeA = typeA != null ? typeA : objType;
        Type type = _typeB = typeB != null ? typeB : objType;
        if (_typeA.isAssignableFrom(_typeB)) {
            return _typeB;
        }
        if (_typeB.isAssignableFrom(_typeA)) {
            return _typeA;
        }
        return null;
    }

    @Override
    protected String toStringInternal() {
        return "(" + this.type.toString() + ")" + this.target.toString();
    }
}

