/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xtend.expression.ast.AbstractVisitor;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.type.baseimpl.TypesComparator;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.util.Pair;
import org.eclipse.internal.xtend.util.Triplet;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.types.AdviceContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.Callback;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.NullEvaluationHandler;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.expression.VetoableCallbackAdapter;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextImpl
implements ExecutionContext {
    private static final Log log = LogFactory.getLog(ExecutionContextImpl.class);
    private static final List<Type> NO_TYPES = Collections.emptyList();
    private static final Type[] NO_TYPES_ARR = new Type[0];
    private static final String[] NO_STRINGS = new String[0];
    protected ResourceManager resourceManager;
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private Map<String, Variable> globalVars;
    private ProgressMonitor monitor;
    private Resource currentResource;
    protected final TypeSystemImpl typeSystem;
    protected ExceptionHandler exceptionHandler;
    protected NullEvaluationHandler nullEvaluationHandler;
    protected VetoableCallback callback;
    protected Map<Resource, Set<Extension>> allExtensionsPerResource = null;
    protected Cache<Triplet<Resource, String, List<Type>>, Extension> extensionsForNameAndTypesCache;
    protected List<Around> registeredExtensionAdvices = new LinkedList<Around>();
    private final TypesComparator typesComparator = new TypesComparator();
    protected Map<Pair<String, List<Type>>, Type> extensionsReturnTypeCache = new HashMap<Pair<String, List<Type>>, Type>();

    public ExecutionContextImpl() {
        this((Map<String, Variable>)null);
    }

    public ExecutionContextImpl(TypeSystemImpl ts) {
        this(ts, null);
    }

    public ExecutionContextImpl(Map<String, Variable> globalVars) {
        this(new ResourceManagerDefaultImpl(), null, new TypeSystemImpl(), new HashMap<String, Variable>(), globalVars, null, null, null, null, null, null, null, null);
    }

    public ExecutionContextImpl(TypeSystemImpl ts, Map<String, Variable> globalVars) {
        this(new ResourceManagerDefaultImpl(), null, ts, new HashMap<String, Variable>(), globalVars, null, null, null, null, null, null, null, null);
    }

    public ExecutionContextImpl(ResourceManager resourceManager, TypeSystemImpl typeSystem, Map<String, Variable> globalVars) {
        this(resourceManager, null, typeSystem, new HashMap<String, Variable>(), globalVars, null, null, null, null, null, null, null, null);
    }

    public ExecutionContextImpl(ResourceManager resourceManager, Resource resource, TypeSystemImpl typeSystem, Map<String, Variable> variables, Map<String, Variable> globalVars, ProgressMonitor monitor, ExceptionHandler exceptionHandler, List<Around> advices, NullEvaluationHandler neh2, Map<Resource, Set<Extension>> extensionPerResourceMap, VetoableCallback callback, Cache<Triplet<Resource, String, List<Type>>, Extension> extensionsForNameAndTypesCache, Map<Pair<String, List<Type>>, Type> extensionsReturnTypeCache) {
        this.allExtensionsPerResource = extensionPerResourceMap != null ? extensionPerResourceMap : new HashMap<Resource, Set<Extension>>();
        this.extensionsForNameAndTypesCache = extensionsForNameAndTypesCache != null ? extensionsForNameAndTypesCache : new ExtensionsForNameAndTypeCache();
        if (extensionsReturnTypeCache != null) {
            this.extensionsReturnTypeCache = extensionsReturnTypeCache;
        }
        this.resourceManager = resourceManager;
        this.currentResource = resource;
        this.typeSystem = typeSystem;
        if (variables != null) {
            this.variables.putAll(variables);
        }
        this.globalVars = globalVars == null ? new HashMap<String, Variable>() : globalVars;
        this.monitor = monitor;
        this.exceptionHandler = exceptionHandler;
        if (advices != null) {
            this.registeredExtensionAdvices = advices;
        }
        this.nullEvaluationHandler = neh2;
        this.callback = callback;
    }

    @Override
    public VetoableCallback getCallback() {
        return this.callback;
    }

    public void registerMetaModel(MetaModel mm) {
        this.typeSystem.registerMetaModel(mm);
    }

    public List<MetaModel> getMetaModels() {
        return this.typeSystem.getMetaModels();
    }

    @Override
    public Operation findOperation(String name, Object target, Object[] params) {
        return this.typeSystem.findOperation(name, target, params);
    }

    @Override
    public Property findProperty(String name, Object target) {
        return this.typeSystem.findProperty(name, target);
    }

    @Override
    public Type[] findTypesForPrefix(String prefix) {
        return this.typeSystem.findTypesForPrefix(prefix, this.getImportedNamespaces());
    }

    @Override
    public Type[] getAllTypes() {
        return this.typeSystem.getAllTypes();
    }

    @Override
    public Set<String> getNamespaces() {
        return this.typeSystem.getNamespaces();
    }

    @Override
    public Type getBooleanType() {
        return this.typeSystem.getBooleanType();
    }

    @Override
    public Type getCollectionType(Type innerType) {
        return this.typeSystem.getCollectionType(innerType);
    }

    @Override
    public Type getFeatureType() {
        return this.typeSystem.getFeatureType();
    }

    @Override
    public Type getIntegerType() {
        return this.typeSystem.getIntegerType();
    }

    @Override
    public Type getListType(Type innerType) {
        return this.typeSystem.getListType(innerType);
    }

    @Override
    public Type getObjectType() {
        return this.typeSystem.getObjectType();
    }

    @Override
    public Type getOperationType() {
        return this.typeSystem.getOperationType();
    }

    @Override
    public Type getPropertyType() {
        return this.typeSystem.getPropertyType();
    }

    @Override
    public Type getRealType() {
        return this.typeSystem.getRealType();
    }

    @Override
    public Type getSetType(Type innerType) {
        return this.typeSystem.getSetType(innerType);
    }

    @Override
    public Type getStaticPropertyType() {
        return this.typeSystem.getStaticPropertyType();
    }

    @Override
    public Type getStringType() {
        return this.typeSystem.getStringType();
    }

    @Override
    public Type getType(Object obj) {
        return this.typeSystem.getType(obj);
    }

    @Override
    public Type getTypeForName(String name) {
        return this.typeSystem.getTypeForName(name, this.getImportedNamespaces());
    }

    protected String[] getImportedNamespaces() {
        return this.currentResource != null ? this.currentResource.getImportedNamespaces() : NO_STRINGS;
    }

    @Override
    public Type getTypeType() {
        return this.typeSystem.getTypeType();
    }

    @Override
    public Type getVoidType() {
        return this.typeSystem.getVoidType();
    }

    public ExecutionContextImpl cloneContext() {
        return new ExecutionContextImpl(this.resourceManager, this.currentResource, this.typeSystem, this.variables, this.globalVars, this.monitor, this.exceptionHandler, this.registeredExtensionAdvices, this.nullEvaluationHandler, this.allExtensionsPerResource, this.callback, this.extensionsForNameAndTypesCache, this.extensionsReturnTypeCache);
    }

    @Deprecated
    public void setFileEncoding(String encoding) {
        if (this.resourceManager != null) {
            this.resourceManager.setFileEncoding(encoding);
        }
    }

    @Override
    public Variable getVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public Map<String, Variable> getVisibleVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public Map<String, Variable> getGlobalVariables() {
        return this.globalVars;
    }

    @Override
    public ExecutionContext cloneWithVariable(Variable v) {
        ExecutionContextImpl result = this.cloneContext();
        result.variables.put(v.getName(), v);
        return result;
    }

    @Override
    public ExecutionContext cloneWithoutVariables() {
        ExecutionContextImpl result = this.cloneContext();
        result.variables.clear();
        return result;
    }

    @Override
    public ExecutionContext cloneWithResource(Resource ns) {
        ExecutionContextImpl ctx = this.cloneContext();
        ctx.currentResource = ns;
        return ctx;
    }

    @Override
    public ExecutionContext cloneWithoutResource() {
        ExecutionContextImpl ctx = this.cloneContext();
        ctx.currentResource = null;
        return ctx;
    }

    @Override
    public ExecutionContext cloneWithoutMonitor() {
        ExecutionContextImpl ctx = this.cloneContext();
        ctx.setMonitor(null);
        return ctx;
    }

    @Override
    public Resource currentResource() {
        return this.currentResource;
    }

    @Override
    public Set<? extends Extension> getAllExtensions() {
        return this.internalAllExtensions(this.currentResource());
    }

    private Set<? extends Extension> internalAllExtensions(Resource currentResource2) {
        Set<Extension> allExtensions = this.allExtensionsPerResource.get(currentResource2);
        if (allExtensions == null) {
            ExecutionContext ctx = this.cloneWithResource(currentResource2);
            allExtensions = new HashSet<Extension>();
            Resource res = currentResource2;
            if (res != null) {
                String[] extensions;
                if (res instanceof XtendFile) {
                    List<Extension> extensionList = ((XtendFile)res).getExtensions();
                    for (Extension element : extensionList) {
                        element.init(ctx);
                        allExtensions.add(this.advise(element));
                    }
                }
                String[] stringArray = extensions = res.getImportedExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    Resource o = this.resourceManager.loadResource(extension, "ext");
                    XtendFile extFile = (XtendFile)o;
                    if (extFile != null) {
                        ctx = this.cloneWithResource(extFile);
                        List<Extension> extensionList = extFile.getPublicExtensions(this.resourceManager, ctx);
                        for (Extension element : extensionList) {
                            element.init(ctx);
                            allExtensions.add(this.advise(element));
                        }
                    }
                    ++n2;
                }
            }
            this.allExtensionsPerResource.put(currentResource2, allExtensions);
        }
        return allExtensions;
    }

    @Override
    public Extension getExtensionForTypes(String functionName, Type[] parameterTypes) {
        ExtensionsForNameAndTypeCacheKey key = new ExtensionsForNameAndTypeCacheKey(this.currentResource(), functionName, parameterTypes != null ? Arrays.asList(parameterTypes) : NO_TYPES);
        return this.extensionsForNameAndTypesCache.get(key);
    }

    @Override
    public Extension getExtension(String functionName, Object[] actualParameters) {
        if (actualParameters.length == 0) {
            return this.getExtensionForTypes(functionName, NO_TYPES_ARR);
        }
        Type[] types = new Type[actualParameters.length];
        int i = 0;
        while (i < types.length) {
            types[i] = this.getType(actualParameters[i]);
            ++i;
        }
        return this.getExtensionForTypes(functionName, types);
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void preTask(Object element) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.preTask(element, (Object)this);
    }

    @Override
    public void postTask(Object element) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.postTask(element, (Object)this);
    }

    @Override
    public void handleRuntimeException(RuntimeException ex, SyntaxElement element, Map<String, Object> additionalContextInfo) {
        if (this.exceptionHandler == null) {
            throw ex;
        }
        this.exceptionHandler.handleRuntimeException(ex, element, this, additionalContextInfo);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void registerExtensionAdvices(String fullyQualifiedName) {
        XtendFile ext = (XtendFile)this.resourceManager.loadResource(fullyQualifiedName, "ext");
        if (ext == null) {
            throw new IllegalArgumentException("Couldn't find extension file '" + fullyQualifiedName + "'");
        }
        List<Around> as = ext.getArounds();
        for (Around around : as) {
            if (this.registeredExtensionAdvices.contains(around)) {
                log.warn((Object)("advice " + around.toString() + " already registered!"));
                continue;
            }
            this.registeredExtensionAdvices.add(around);
        }
    }

    @Override
    public List<Around> getExtensionAdvices() {
        return this.registeredExtensionAdvices;
    }

    private Extension advise(Extension element) {
        if (this.registeredExtensionAdvices == null || this.registeredExtensionAdvices.isEmpty()) {
            return element;
        }
        Extension _element = element;
        for (Around a : this.getExtensionAdvices()) {
            if (!a.nameMatches(_element.getQualifiedName())) continue;
            List<Type> paramTypes = a.getParamTypes(this);
            List<Type> extPTypes = _element.getParameterTypes();
            int diff = extPTypes.size() - paramTypes.size();
            if (diff < 0) continue;
            if (diff > 0 && a.isWildparams()) {
                int i = 0;
                while (i < diff) {
                    paramTypes.add(this.getObjectType());
                    ++i;
                }
            }
            if (this.typesComparator.compare(paramTypes, extPTypes) < 0) continue;
            _element = new ExtensionAdvisor(a, _element);
        }
        return _element;
    }

    @Override
    public Object handleNullEvaluation(SyntaxElement element) {
        if (this.nullEvaluationHandler != null) {
            return this.nullEvaluationHandler.handleNullEvaluation(element, this);
        }
        return null;
    }

    @Override
    public void release() {
        this.typeSystem.release();
    }

    @Deprecated
    public void setCallBack(Callback callback) {
        this.callback = new VetoableCallbackAdapter(callback);
    }

    public void setVetoableCallBack(VetoableCallback callback) {
        this.callback = callback;
    }

    @Override
    public Type getReturnType(Extension extension, Type[] paramTypes, Set<AnalysationIssue> issues) {
        List<Type> value = paramTypes.length > 0 ? Arrays.asList(paramTypes) : NO_TYPES;
        Pair<String, List<Type>> key = new Pair<String, List<Type>>(extension.getQualifiedName(), value);
        if (this.extensionsReturnTypeCache.containsKey(key)) {
            return this.extensionsReturnTypeCache.get(key);
        }
        Type result = extension.getReturnType(paramTypes, this, issues);
        this.extensionsReturnTypeCache.put(key, result);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtensionAdvisor
    implements Extension {
        private final Extension delegate;
        private final Around advice;

        public ExtensionAdvisor(Around advice, Extension delegate) {
            this.delegate = delegate;
            this.advice = advice;
        }

        @Override
        public Object evaluate(Object[] parameters, ExecutionContext ctx) {
            ExecutionContext _ctx = ctx;
            _ctx = _ctx.cloneWithVariable(new Variable("ctx", new AdviceContext(this.delegate, _ctx, parameters)));
            int i = 0;
            while (i < this.advice.getParams().size()) {
                _ctx = _ctx.cloneWithVariable(new Variable(this.advice.getParams().get(i).getName().toString(), parameters[i]));
                ++i;
            }
            _ctx = _ctx.cloneWithResource(this.advice.getParent());
            return this.advice.getExpression().evaluate(_ctx);
        }

        @Override
        public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
            this.delegate.analyze(ctx, issues);
        }

        @Override
        public int getEnd() {
            return this.delegate.getEnd();
        }

        @Override
        public ExtensionFile getExtensionFile() {
            return this.delegate.getExtensionFile();
        }

        @Override
        public String getFileName() {
            return this.delegate.getFileName();
        }

        @Override
        public List<DeclaredParameter> getFormalParameters() {
            return this.delegate.getFormalParameters();
        }

        @Override
        public int getLine() {
            return this.delegate.getLine();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public List<String> getParameterNames() {
            return this.delegate.getParameterNames();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.delegate.getParameterTypes();
        }

        @Override
        public Type getReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
            return ctx.getReturnType(this.delegate, parameters, issues);
        }

        @Override
        public Type getReturnType() {
            return this.delegate.getReturnType();
        }

        @Override
        public Identifier getReturnTypeIdentifier() {
            return this.delegate.getReturnTypeIdentifier();
        }

        @Override
        public int getStart() {
            return this.delegate.getStart();
        }

        @Override
        public String getNameString(ExecutionContext context) {
            return this.delegate.getNameString(context);
        }

        @Override
        public void init(ExecutionContext ctx) {
            this.delegate.init(ctx);
        }

        @Override
        public boolean isCached() {
            return this.delegate.isCached();
        }

        @Override
        public boolean isPrivate() {
            return this.delegate.isPrivate();
        }

        @Override
        public void setExtensionFile(ExtensionFile file) {
            this.delegate.setExtensionFile(file);
        }

        @Override
        public String toOutlineString() {
            return this.delegate.toOutlineString();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public String getQualifiedName() {
            return this.delegate.getQualifiedName();
        }

        @Override
        public final Object accept(AbstractVisitor visitor) {
            return visitor.visit(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ExtensionsForNameAndTypeCache
    extends Cache<Triplet<Resource, String, List<Type>>, Extension> {
        ExtensionsForNameAndTypeCache() {
        }

        @Override
        protected Extension createNew(Triplet<Resource, String, List<Type>> arg0) {
            return PolymorphicResolver.getExtension(ExecutionContextImpl.this.internalAllExtensions(arg0.getFirst()), arg0.getSecond(), arg0.getThird());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ExtensionsForNameAndTypeCacheKey
    extends Triplet<Resource, String, List<Type>> {
        final int hash = super.hashCode();

        public ExtensionsForNameAndTypeCacheKey(Resource first, String second, List<Type> third) {
            super(first, second, third);
        }

        @Override
        public int hashCode() {
            return this.hash;
        }
    }
}

