/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.resource.IEObjectDescription;

@Singleton
public class IdeContentProposalPriorities {
    private int crossRefPriority = 500;
    private int defaultPriority = 400;
    private int keywordPriority = 300;

    protected int adjustPriority(ContentAssistEntry entry, int priority) {
        if (entry == null) {
            return priority;
        }
        int adjustedPriority = priority;
        if (!Character.isLetter(entry.getProposal().charAt(0))) {
            adjustedPriority -= 30;
        }
        if (Objects.equal((Object)entry.getProposal(), (Object)entry.getPrefix())) {
            adjustedPriority -= 20;
        }
        return adjustedPriority;
    }

    public int getCrossRefPriority(IEObjectDescription objectDesc, ContentAssistEntry entry) {
        return this.adjustPriority(entry, this.crossRefPriority);
    }

    public int getDefaultPriority(ContentAssistEntry entry) {
        return this.adjustPriority(entry, this.defaultPriority);
    }

    public int getKeywordPriority(String keyword, ContentAssistEntry entry) {
        return this.adjustPriority(entry, this.keywordPriority);
    }

    protected int getCrossRefPriority() {
        return this.crossRefPriority;
    }

    protected void setCrossRefPriority(int crossRefPriority) {
        this.crossRefPriority = crossRefPriority;
    }

    protected int getDefaultPriority() {
        return this.defaultPriority;
    }

    protected void setDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    protected int getKeywordPriority() {
        return this.keywordPriority;
    }

    protected void setKeywordPriority(int keywordPriority) {
        this.keywordPriority = keywordPriority;
    }
}

