/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.refactoring;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.RenameChange;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;

public class RenameContext {
    private final List<? extends RenameChange> changes;
    private final ResourceSet resourceSet;
    private final IChangeSerializer changeSerializer;
    private final RefactoringIssueAcceptor issues;

    public RenameContext(List<? extends RenameChange> changes, ResourceSet resourceSet, IChangeSerializer changeSerializer, RefactoringIssueAcceptor issues) {
        this.changes = changes;
        this.resourceSet = resourceSet;
        this.changeSerializer = changeSerializer;
        this.issues = issues;
    }

    public void addModification(RenameChange change, IChangeSerializer.IModification<EObject> modification) {
        EObject target = this.resourceSet.getEObject(change.getTargetURI(), true);
        if (target != null) {
            EcoreUtil.resolveAll((Resource)target.eResource());
            this.changeSerializer.addModification(target, modification);
        } else {
            this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, "Element cannot be found", change.getTargetURI());
        }
    }

    public List<? extends RenameChange> getChanges() {
        return this.changes;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IChangeSerializer getChangeSerializer() {
        return this.changeSerializer;
    }

    public RefactoringIssueAcceptor getIssues() {
        return this.issues;
    }
}

