/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.xtext.ui.editor.embedded.MarkRegionTargetWithoutStatusline;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerMarkAction
extends TextViewerAction {
    public static final int SET_MARK = 0;
    public static final int CLEAR_MARK = 1;
    public static final int SWAP_MARK = 2;
    private final int fType;
    private MarkRegionTargetWithoutStatusline markRegionTarget;

    public TextViewerMarkAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int type) {
        super(bundle, prefix, viewer);
        this.fType = type;
    }

    public void run() {
        ITextViewer editor = this.getTextViewer();
        if (editor == null || this.markRegionTarget == null) {
            return;
        }
        switch (this.fType) {
            case 0: {
                this.markRegionTarget.setMarkAtCursor(true);
                break;
            }
            case 1: {
                this.markRegionTarget.setMarkAtCursor(false);
                break;
            }
            case 2: {
                this.markRegionTarget.swapMarkAndCursor();
            }
        }
    }

    @Override
    public void setViewer(ITextViewer viewer) {
        super.setViewer(viewer);
        this.markRegionTarget = viewer != null ? new MarkRegionTargetWithoutStatusline(viewer) : null;
    }
}

