/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class TypeAssigner
implements ITypeAssigner {
    private final AbstractTypeComputationState state;

    protected TypeAssigner(AbstractTypeComputationState state) {
        this.state = state;
    }

    @Override
    public AbstractTypeComputationState getForkedState() {
        return this.state;
    }

    @Override
    public void assignType(JvmIdentifiableElement element, LightweightTypeReference actualType) {
        this.assignType(element, actualType, true);
    }

    protected void assignType(JvmIdentifiableElement element, LightweightTypeReference actualType, boolean addToChildScope) {
        if (actualType != null) {
            this.state.getResolvedTypes().setType(element, actualType);
        } else {
            this.state.getResolvedTypes().setType(element, this.state.getReferenceOwner().newAnyTypeReference());
        }
        if (addToChildScope) {
            this.state.addLocalToCurrentScope(element);
        }
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.state.getReferenceOwner();
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.getReferenceOwner().toLightweightTypeReference(reference);
    }
}

