/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Maps2 {
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap<K, V>(Maps2.capacity(expectedSize)){
            private static final long serialVersionUID = 1L;

            @Override
            public void clear() {
                if (this.isEmpty()) {
                    return;
                }
                super.clear();
            }
        };
    }

    public static <K, V> void putIntoListMap(K key, V value, Map<? super K, List<V>> map) {
        ArrayList list = map.get(key);
        if (list == null) {
            list = Lists.newArrayListWithCapacity((int)2);
            map.put(key, list);
        }
        list.add(value);
    }

    public static <K, V> void putIntoSetMap(K key, V value, Map<? super K, Set<V>> map) {
        HashSet list = map.get(key);
        if (list == null) {
            list = Sets.newHashSetWithExpectedSize((int)2);
            map.put(key, list);
        }
        list.add(value);
    }

    public static <K, V> void putAllIntoListMap(K key, Collection<? extends V> values, Map<? super K, List<V>> map) {
        ArrayList list = map.get(key);
        if (list == null) {
            list = Lists.newArrayList(values);
            map.put(key, list);
        } else {
            list.addAll(values);
        }
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0);
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }
}

