/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Iterator;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;

public abstract class AbstractClassDiagramTextProvider
extends AbstractDiagramTextProvider {
    public static int GEN_MODIFIERS = 1;
    public static int GEN_MEMBERS = 2;
    public static int GEN_EXTENDS = 4;
    public static int GEN_IMPLEMENTS = 8;
    public static int GEN_ASSOCIATIONS = 16;
    public static int GEN_CLASS_HYPERLINKS = 32;
    protected static final String CLASS_TYPE = "class";
    protected static final String INTERFACE_TYPE = "interface";
    protected static final String ENUM_TYPE = "enum";
    protected static final String ABSTRACT_MODIFIER = "abstract";
    protected static final String BIDIRECTIONAL_ASSOCIATION_RELATION = "--";
    protected static final String ASSOCIATION_RELATION = "-->";
    protected static final String EXTENDS_RELATION = "<|--";
    protected static final String IMPLEMENTS_RELATION = "<|..";

    public AbstractClassDiagramTextProvider() {
    }

    public AbstractClassDiagramTextProvider(Class<?> editorType) {
        super(editorType);
    }

    protected void appendClassStart(String modifiers, String classType, String name, String link, StringBuilder buffer) {
        this.appendClassStart(modifiers, classType, name, link, null, buffer);
    }

    protected void appendNameDeclaration(String label, String logicalName, StringBuilder buffer) {
        boolean as;
        boolean bl = as = logicalName != null && !logicalName.equals(label);
        if (as) {
            buffer.append("\"");
        }
        buffer.append(label);
        if (as) {
            buffer.append("\"");
            buffer.append(" as ");
            buffer.append(logicalName);
        }
    }

    protected void appendNameDeclaration(String name, StringBuilder buffer) {
        if (name == null) {
            name = "?";
        }
        this.appendNameDeclaration(name, this.getLogicalName(name), buffer);
    }

    protected void appendClassStart(String modifiers, String classType, String name, String link, String color, StringBuilder buffer) {
        if (modifiers != null) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        buffer.append(classType);
        buffer.append(" ");
        this.appendNameDeclaration(name, buffer);
        this.appendLink(link, false, buffer);
        if (color != null) {
            buffer.append(" #");
            buffer.append(color);
        }
        buffer.append(" {\n");
    }

    protected void appendClassEnd(StringBuilder buffer) {
        buffer.append("}\n");
    }

    private void appendMember(String modifiers, String visibility, String type, String name, Iterable<String> parameters, StringBuilder buffer) {
        buffer.append("\t");
        if (visibility != null) {
            buffer.append(visibility);
        }
        if (modifiers != null) {
            buffer.append(modifiers);
            buffer.append(" ");
        }
        if (type != null) {
            buffer.append(type);
            buffer.append(" ");
        }
        if (name != null) {
            buffer.append(name);
        }
        if (parameters != null) {
            buffer.append("(");
            Iterator<String> it = parameters.iterator();
            while (it.hasNext()) {
                buffer.append(it.next());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
        }
        buffer.append("\n");
    }

    protected void appendAttribute(String modifiers, String visibility, String type, String name, StringBuilder buffer) {
        this.appendMember(modifiers, visibility, type, name, null, buffer);
    }

    protected void appendOperation(String modifiers, String visibility, String type, String name, Iterable<String> parameters, StringBuilder buffer) {
        this.appendMember(modifiers, visibility, type, name, parameters, buffer);
    }

    protected void appendGeneralisation(String subClass, String superClass, boolean isImplements, StringBuilder buffer) {
        buffer.append(this.getLogicalName(superClass));
        buffer.append(" ");
        buffer.append(isImplements ? IMPLEMENTS_RELATION : EXTENDS_RELATION);
        buffer.append(" ");
        buffer.append(this.getLogicalName(subClass));
        buffer.append("\n");
    }

    protected void appendAssociation(String class1, boolean cont1, String role1, int mult1, String direction, String class2, boolean cont2, String role2, int mult2, String name, StringBuilder buffer) {
        String relation = role1 != null ? BIDIRECTIONAL_ASSOCIATION_RELATION : ASSOCIATION_RELATION;
        String startLabel = this.getRoleLabel(role1, mult1);
        String endLabel = this.getRoleLabel(role2, mult2);
        this.appendRelation(class1, cont1, startLabel, relation, direction, class2, cont2, endLabel, name, buffer);
    }

    private String getRoleLabel(String role, int mult) {
        String label = null;
        if (role != null) {
            label = role;
            if (mult != 0) {
                label = String.valueOf(label) + " " + (mult > 0 ? Integer.valueOf(mult) : "*");
            }
        }
        return label;
    }
}

