/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.types.validation;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.types.scoping.TypesImportUriGlobalScopeProvider;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.IntExp;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.ModelContainer;
import org.eclipse.comma.types.types.NamedElement;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.CommaUtilities;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.comma.types.validation.AbstractTypesValidator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TypesValidator
extends AbstractTypesValidator {
    @Inject
    @Extension
    private CommaUtilities _commaUtilities;
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;

    protected void checkForNameDuplications(Iterable<? extends NamedElement> elements, String desc, String code, String ... issueData) {
        HashMultimap multiMap = HashMultimap.create();
        for (NamedElement namedElement : elements) {
            multiMap.put((Object)namedElement.getName(), (Object)namedElement);
        }
        Set set = multiMap.asMap().entrySet();
        for (Map.Entry entry : set) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (NamedElement d : duplicates) {
                this.error("Duplicate " + desc + " name", d, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, code, issueData);
            }
        }
    }

    protected void placePredefinedTypes(Multimap<QualifiedName, IEObjectDescription> map) {
        Functions.Function1<IEObjectDescription, Boolean> _function;
        Collection intType = map.get((Object)QualifiedName.EMPTY.append("int"));
        boolean _exists = IterableExtensions.exists((Iterable)intType, (Functions.Function1)(_function = new Functions.Function1<IEObjectDescription, Boolean>(){

            public Boolean apply(IEObjectDescription it) {
                return it.getEObjectURI().toString().contains(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"org", "eclipse", "comma", "types", "types.types"})), (CharSequence)"/"));
            }
        }));
        if (_exists) {
            return;
        }
        map.put((Object)QualifiedName.EMPTY.append("int"), null);
        map.put((Object)QualifiedName.EMPTY.append("bool"), null);
        map.put((Object)QualifiedName.EMPTY.append("real"), null);
        map.put((Object)QualifiedName.EMPTY.append("string"), null);
        map.put((Object)QualifiedName.EMPTY.append("void"), null);
        map.put((Object)QualifiedName.EMPTY.append("any"), null);
        map.put((Object)QualifiedName.EMPTY.append("bulkdata"), null);
        map.put((Object)QualifiedName.EMPTY.append("id"), null);
    }

    @Check
    public void checkFileImportTransitively(ModelContainer root) {
        Functions.Function1<Import, Boolean> _function = new Functions.Function1<Import, Boolean>(){

            public Boolean apply(Import it) {
                return it instanceof FileImport;
            }
        };
        boolean _exists = IterableExtensions.exists(root.getImports(), (Functions.Function1)_function);
        if (_exists) {
            boolean _not;
            LinkedHashSet<URI> knownURIs = new LinkedHashSet<URI>(5);
            knownURIs.add(root.eResource().getURI());
            boolean _usesOnlyFileImports = this.usesOnlyFileImports(root, knownURIs);
            boolean bl = _not = !_usesOnlyFileImports;
            if (_not) {
                this.error("Combining namespace and file imports locally and transitively is not allowed. Check all import statements.", (EStructuralFeature)TypesPackage.Literals.MODEL_CONTAINER__IMPORTS);
            }
        }
    }

    @Check
    public void checkDuplicatedRecordFields(RecordTypeDecl type) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)type.getFields(), "record field", null, new String[0]);
    }

    @Check
    public void checkCircularHierarchy(RecordTypeDecl type) {
        boolean _contains = TypeUtilities.getAllParents(type).contains(type);
        if (_contains) {
            this.error("Cycle in the extension hierarchy", (EStructuralFeature)TypesPackage.Literals.RECORD_TYPE_DECL__PARENT);
        }
    }

    @Check
    public void checkOverridenRecordFields(RecordTypeDecl type) {
        boolean _tripleNotEquals;
        RecordTypeDecl _parent = type.getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            List<RecordField> inheritedFields = TypeUtilities.getAllFields(type.getParent());
            EList<RecordField> _fields = type.getFields();
            for (final RecordField f : _fields) {
                boolean _not;
                Functions.Function1<RecordField, Boolean> _function = new Functions.Function1<RecordField, Boolean>(){

                    public Boolean apply(RecordField ff) {
                        return ff.getName().equals(f.getName());
                    }
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter(inheritedFields, (Functions.Function1)_function));
                boolean bl2 = _not = !_isEmpty;
                if (!_not) continue;
                this.error("Local field overrides inherited field", f, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void CheckIfRecordFieldsFormCyclicGraph(RecordTypeDecl type) {
        HashSet<RecordTypeDecl> visited = new HashSet<RecordTypeDecl>();
        boolean _containsCycleGraph = this.containsCycleGraph(type, visited);
        if (_containsCycleGraph) {
            this.error("found cyclic graph   ", (EStructuralFeature)TypesPackage.Literals.RECORD_TYPE_DECL__FIELDS);
        }
    }

    public boolean containsCycleGraph(RecordTypeDecl record, Set<RecordTypeDecl> visited) {
        boolean _contains = visited.contains(record);
        if (_contains) {
            return true;
        }
        visited.add(record);
        Functions.Function1<RecordField, Boolean> _function = new Functions.Function1<RecordField, Boolean>(){

            public Boolean apply(RecordField f) {
                return TypeUtilities.isRecordType(f.getType());
            }
        };
        Functions.Function1<RecordField, RecordTypeDecl> _function_1 = new Functions.Function1<RecordField, RecordTypeDecl>(){

            public RecordTypeDecl apply(RecordField it) {
                return TypesValidator.this.getRecordType(it);
            }
        };
        Set childRecords = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(record.getFields(), (Functions.Function1)_function), (Functions.Function1)_function_1));
        for (RecordTypeDecl childRecord : childRecords) {
            Set visitedCopy;
            boolean _containsCycleGraph = this.containsCycleGraph(childRecord, visitedCopy = IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)((RecordTypeDecl[])Conversions.unwrapArray(visited, RecordTypeDecl.class)).clone()))));
            if (!_containsCycleGraph) continue;
            return true;
        }
        return false;
    }

    public RecordTypeDecl getRecordType(RecordField recordField) {
        TypeObject _typeObject = TypeUtilities.getTypeObject(recordField.getType());
        return (RecordTypeDecl)_typeObject;
    }

    @Check
    public void checkDuplicatedEnumElements(EnumTypeDecl type) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)type.getLiterals(), "enumeration literal", null, new String[0]);
    }

    @Check
    public void checkEnumLiteralValues(EnumTypeDecl type) {
        int currentValue = -1;
        EList<EnumElement> _literals = type.getLiterals();
        for (EnumElement l : _literals) {
            boolean _lessEqualsThan;
            boolean _tripleEquals;
            IntExp _value = l.getValue();
            boolean bl = _tripleEquals = _value == null;
            if (_tripleEquals) {
                ++currentValue;
                continue;
            }
            int _value_1 = l.getValue().getValue();
            boolean bl2 = _lessEqualsThan = _value_1 <= currentValue;
            if (_lessEqualsThan) {
                this.error("Enum value has to be greater than the previous value", l, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
                return;
            }
            currentValue = l.getValue().getValue();
        }
    }

    @Check
    public void checkDuplicatedTypeDeclarations(TypesModel typedecl) {
        this.checkForNameDuplications((Iterable<? extends NamedElement>)typedecl.getTypes(), "type declaration", null, new String[0]);
    }

    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", imp, (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
        } else {
            boolean _not_1;
            EClass _typesModel;
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EClass _eClass = ((EObject)IteratorExtensions.head((Iterator)r.getAllContents())).eClass();
            boolean _equals = Objects.equal((Object)_eClass, (Object)(_typesModel = TypesPackage.eINSTANCE.getTypesModel()));
            boolean bl2 = _not_1 = !_equals;
            if (_not_1) {
                this.error("Only imports for type definitions are allowed", imp, (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
            }
        }
    }

    @Check
    public void checkForAnyType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("any")) {
            this.error("Usage of type any is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkForVoidType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("void")) {
            this.error("Usage of type void is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkForIdType(Type t) {
        if (t.getType() instanceof SimpleTypeDecl && t.getType().getName().equals("id")) {
            this.error("Usage of type id is not allowed", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Check
    public void checkKeyType(MapTypeConstructor mtc) {
        if (!(TypeUtilities.getKeyType(mtc) instanceof EnumTypeDecl) && !(TypeUtilities.getKeyType(mtc) instanceof SimpleTypeDecl)) {
            this.error("The type of map keys has to be enumeration or simple type", (EStructuralFeature)TypesPackage.Literals.TYPE__TYPE);
        }
    }

    @Inject
    public void register(EValidatorRegistrar registrar) {
        try {
            super.register(registrar);
            String VALIDATOR_ID = "org.eclipse.comma.types.commaValidator";
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            if (reg != null) {
                IConfigurationElement[] extensions;
                IConfigurationElement[] iConfigurationElementArray = extensions = reg.getConfigurationElementsFor("org.eclipse.comma.types.commaValidator");
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    Object o = e.createExecutableExtension("class");
                    boolean _startsWith = ((Object)((Object)this)).getClass().getSimpleName().startsWith(e.getAttribute("language"));
                    if (_startsWith) {
                        List<EPackage> _ePackages = this.getEPackages();
                        for (EPackage ePackage : _ePackages) {
                            registrar.register(ePackage, (EValidator)o);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Check
    public void checkGlobalUniquenessOfTypes(TypesModel typesModel) {
        boolean _isEmpty = typesModel.getTypes().isEmpty();
        if (_isEmpty) {
            return;
        }
        Multimap<QualifiedName, IEObjectDescription> multiMap = this.getImportedTypes(typesModel);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, typesModel, (EStructuralFeature)TypesPackage.Literals.TYPES_MODEL__TYPES);
        }
        EList<TypeDecl> _types = typesModel.getTypes();
        for (TypeDecl t : _types) {
            QualifiedName fqn = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)t);
            boolean _containsKey = multiMap.containsKey((Object)fqn);
            if (!_containsKey) continue;
            this.error("Local declaration duplicates imported type", t, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    public Multimap<QualifiedName, IEObjectDescription> getImportedTypes(ModelContainer context) {
        Multimap<QualifiedName, IEObjectDescription> _xblockexpression = null;
        HashSet types = new HashSet();
        Multimap<QualifiedName, IEObjectDescription> multiMap = HashMultimap.create();
        if (context.getName() == null && !IterableExtensions.exists(context.getImports(), (Functions.Function1)new Functions.Function1<Import, Boolean>(){

            public Boolean apply(Import it) {
                return it instanceof NamespaceImport;
            }
        })) {
            LinkedHashSet<URI> knownURIs = new LinkedHashSet<URI>(3);
            knownURIs.add(context.eResource().getURI());
            LinkedHashSet<URI> importedUris = TypesImportUriGlobalScopeProvider.traverseImportedURIs(context.eResource(), knownURIs);
            for (URI uri : importedUris) {
                Iterables.addAll(types, (Iterable)this._commaUtilities.getResourceDescription(EcoreUtil2.getResource((Resource)context.eResource(), (String)uri.toString())).getExportedObjectsByType(TypesPackage.eINSTANCE.getTypeDecl()));
            }
            for (IEObjectDescription t : types) {
                multiMap.put((Object)t.getQualifiedName(), (Object)t);
            }
        } else {
            multiMap = this.getGlobalDeclarations(context, TypesPackage.eINSTANCE.getTypeDecl());
        }
        this.placePredefinedTypes(multiMap);
        _xblockexpression = multiMap;
        return _xblockexpression;
    }

    public Multimap<QualifiedName, IEObjectDescription> getGlobalDeclarations(EObject context, EClass type) {
        HashMultimap _xblockexpression = null;
        Iterable<IEObjectDescription> allVisibleDeclarations = this._commaUtilities.getVisibleEObjectDescriptions(context, type);
        Iterable allExportedDeclarations = this._commaUtilities.getResourceDescription(context).getExportedObjectsByType(type);
        Set difference = IterableExtensions.toSet(allVisibleDeclarations);
        difference.removeAll(IterableExtensions.toSet((Iterable)allExportedDeclarations));
        final HashMultimap multiMap = HashMultimap.create();
        Consumer<IEObjectDescription> _function = new Consumer<IEObjectDescription>(){

            @Override
            public void accept(IEObjectDescription it) {
                multiMap.put((Object)it.getQualifiedName(), (Object)it);
            }
        };
        difference.forEach(_function);
        _xblockexpression = multiMap;
        return _xblockexpression;
    }

    public boolean usesOnlyFileImports(ModelContainer root, Set<URI> knownURIs) {
        boolean _not;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter(root.getImports(), NamespaceImport.class));
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return false;
        }
        Iterable _filter = Iterables.filter(root.getImports(), FileImport.class);
        for (FileImport fileImport : _filter) {
            boolean _not_1;
            Resource importedResource = EcoreUtil2.getResource((Resource)root.eResource(), (String)fileImport.getImportURI());
            if (importedResource == null || !(IteratorExtensions.head((Iterator)importedResource.getAllContents()) instanceof ModelContainer) || knownURIs.contains(importedResource.getURI())) continue;
            knownURIs.add(importedResource.getURI());
            EObject _head = (EObject)IteratorExtensions.head((Iterator)importedResource.getAllContents());
            boolean _usesOnlyFileImports = this.usesOnlyFileImports((ModelContainer)_head, knownURIs);
            boolean bl2 = _not_1 = !_usesOnlyFileImports;
            if (!_not_1) continue;
            return false;
        }
        return true;
    }
}

