/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdi.hcr.VirtualMachine;
import org.eclipse.jdi.internal.FieldImpl;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.ValueImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDILambdaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIReturnValueVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDILocalVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIPlaceholderValue;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;
import org.eclipse.jdt.internal.debug.core.model.MethodResult;

public class JDIStackFrame
extends JDIDebugElement
implements IJavaStackFrame {
    private int fDepth = -2;
    private StackFrame fStackFrame;
    private JDIThread fThread;
    private List<IJavaVariable> fVariables;
    private ObjectReference fThisObject;
    private String fReceivingTypeName;
    private boolean fRefreshVariables = true;
    private boolean fIsOutOfSynch = false;
    private boolean fLocalsAvailable = true;
    private Location fLocation;
    private boolean fIsTop;
    private static final String SYNTHETIC_OUTER_LOCAL_PREFIX = new String(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX);

    public JDIStackFrame(JDIThread thread, StackFrame frame, int depth) {
        super((JDIDebugTarget)thread.getDebugTarget());
        this.setThread(thread);
        this.bind(frame, depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDIStackFrame bind(StackFrame frame, int depth) {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            Location location;
            Method method;
            block9: {
                if (this.fDepth == -2) {
                    this.fStackFrame = frame;
                    this.fDepth = depth;
                    this.fLocation = frame.location();
                    return this;
                }
                if (depth != -1) break block9;
                this.fDepth = -1;
                this.fStackFrame = null;
                this.fIsTop = false;
                return null;
            }
            if (this.fDepth == depth && (method = (location = frame.location()).method()).equals(this.fLocation.method())) {
                try {
                    if (method.declaringType().defaultStratum().equals("Java") || this.equals(this.getSourceName(location), this.getSourceName(this.fLocation))) {
                        this.fStackFrame = frame;
                        this.fLocation = location;
                        this.clearCachedData();
                        return this;
                    }
                }
                catch (DebugException debugException) {}
            }
            this.bind(null, -1);
            return new JDIStackFrame(this.fThread, frame, depth);
        }
    }

    public IThread getThread() {
        return this.fThread;
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.isTopStackFrame() && !this.isObsolete() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        return this.exists() && !this.isObsolete() && this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        block5: {
            if (this.exists() && !this.isObsolete() && this.getThread().canStepReturn()) break block5;
            return false;
        }
        try {
            List<IJavaStackFrame> frames = ((JDIThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                int index;
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                boolean aboveObsoleteFrame = false;
                if (!bottomFrame && (index = frames.indexOf(this)) < frames.size() - 1 && ((JDIStackFrame)frames.get(index + 1)).isObsolete()) {
                    aboveObsoleteFrame = true;
                }
                return !bottomFrame && !aboveObsoleteFrame;
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getUnderlyingMethod() {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            return this.fLocation.method();
        }
    }

    public IVariable[] getVariables() throws DebugException {
        List<IJavaVariable> list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IJavaVariable> getVariables0() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.fVariables == null) {
                List<IJavaStackFrame> frames;
                int previousIndex;
                if (this.isNative()) {
                    this.requestFailed(JDIDebugModelMessages.JDIStackFrame_Variable_information_unavailable_for_native_methods, null);
                }
                Method method = this.getUnderlyingMethod();
                this.fVariables = new ArrayList<IJavaVariable>();
                if (method.isStatic()) {
                    List<Field> allFields = null;
                    ReferenceType declaringType = method.declaringType();
                    try {
                        allFields = declaringType.allFields();
                    }
                    catch (RuntimeException e) {
                        this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_fields, e.toString()), e);
                        return Collections.EMPTY_LIST;
                    }
                    if (allFields != null) {
                        for (Field field : allFields) {
                            if (!field.isStatic()) continue;
                            this.fVariables.add(new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, declaringType));
                        }
                        Collections.sort(this.fVariables, (a, b) -> {
                            JDIFieldVariable v1 = (JDIFieldVariable)a;
                            JDIFieldVariable v2 = (JDIFieldVariable)b;
                            try {
                                return v1.getName().compareToIgnoreCase(v2.getName());
                            }
                            catch (DebugException de) {
                                this.logError((Exception)((Object)de));
                                return -1;
                            }
                        });
                    }
                } else {
                    ObjectReference t = this.getUnderlyingThisObject();
                    if (t != null) {
                        this.fVariables.add(new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), t));
                    }
                }
                if (LambdaUtils.isLambdaFrame(this) && (previousIndex = (frames = this.fThread.computeStackFrames()).indexOf(this) + 1) > 0 && previousIndex < frames.size()) {
                    IJavaStackFrame previousFrame = frames.get(previousIndex);
                    ObjectReference underlyingThisObject = ((JDIStackFrame)previousFrame).getUnderlyingThisObject();
                    JDIValue closureValue = JDIValue.createValue((JDIDebugTarget)this.getDebugTarget(), underlyingThisObject);
                    this.tryToResolveLambdaVariableNames(closureValue, underlyingThisObject);
                    this.fVariables.add(new JDILambdaVariable(closureValue));
                }
                this.addStepReturnValue(this.fVariables);
                for (LocalVariable var : this.getUnderlyingVisibleVariables()) {
                    this.fVariables.add(new JDILocalVariable(this, var));
                }
            } else if (this.fRefreshVariables) {
                this.updateVariables();
            }
            this.fRefreshVariables = false;
            return this.fVariables;
        }
    }

    protected void tryToResolveLambdaVariableNames(IJavaValue value, ObjectReference underlyingThisObject) {
        if (!this.isProbablyJavaCode()) {
            return;
        }
        try {
            IType type = JavaDebugUtils.resolveType(value.getJavaType());
            if (type == null) {
                return;
            }
            ASTParser parser = ASTParser.newParser((int)11);
            parser.setResolveBindings(true);
            parser.setSource(type.getTypeRoot());
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            try {
                List<Location> allLineLocations = this.getUnderlyingMethod().allLineLocations();
                int lineNo = allLineLocations.get(0).lineNumber();
                cu.accept((ASTVisitor)new LambdaASTVisitor(false, underlyingThisObject, this.getUnderlyingMethod().isStatic(), cu, lineNo));
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        catch (CoreException e) {
            this.logError((Exception)((Object)e));
        }
    }

    protected boolean isProbablyJavaCode() {
        try {
            String sourceName = this.getSourceName();
            return sourceName == null || sourceName.endsWith(".java");
        }
        catch (DebugException debugException) {
            return true;
        }
    }

    private void addStepReturnValue(List<IJavaVariable> variables) {
        if (this.fIsTop) {
            MethodResult methodResult = this.fThread.getMethodResult();
            if (methodResult != null && methodResult.fResultType != null) {
                switch (methodResult.fResultType) {
                    case returned: {
                        if (this.fDepth + 1 != methodResult.fTargetFrameCount) {
                            return;
                        }
                        String name = MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_ReturnValue, methodResult.fMethod.name());
                        variables.add(0, new JDIReturnValueVariable(name, (IJavaValue)JDIValue.createValue(this.getJavaDebugTarget(), methodResult.fValue), true));
                        break;
                    }
                    case returning: {
                        String name = MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_ReturningValue, methodResult.fMethod.name());
                        variables.add(0, new JDIReturnValueVariable(name, (IJavaValue)JDIValue.createValue(this.getJavaDebugTarget(), methodResult.fValue), true));
                        break;
                    }
                    case threw: {
                        if (this.fDepth + 1 > methodResult.fTargetFrameCount) {
                            return;
                        }
                        String name = MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_ExceptionThrown, methodResult.fMethod.name());
                        variables.add(0, new JDIReturnValueVariable(name, (IJavaValue)JDIValue.createValue(this.getJavaDebugTarget(), methodResult.fValue), true));
                        break;
                    }
                    case throwing: {
                        String name = MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_ThrowingException, methodResult.fMethod.name());
                        variables.add(0, new JDIReturnValueVariable(name, (IJavaValue)JDIValue.createValue(this.getJavaDebugTarget(), methodResult.fValue), true));
                        break;
                    }
                    case step_timeout: {
                        String msg = JDIDebugModelMessages.JDIStackFrame_NotObservedBecauseOfTimeout;
                        variables.add(0, new JDIReturnValueVariable(JDIDebugModelMessages.JDIStackFrame_NoMethodReturnValue, (IJavaValue)new JDIPlaceholderValue(this.getJavaDebugTarget(), msg), false));
                        break;
                    }
                }
            } else if (JDIThread.showStepResultIsEnabled(this.getDebugTarget())) {
                variables.add(0, new JDIReturnValueVariable(JDIDebugModelMessages.JDIStackFrame_NoMethodReturnValue, (IJavaValue)new JDIPlaceholderValue(this.getJavaDebugTarget(), ""), false));
            }
        }
    }

    public String getName() throws DebugException {
        return this.getMethodName();
    }

    @Override
    public List<String> getArgumentTypeNames() throws DebugException {
        try {
            Method underlyingMethod = this.getUnderlyingMethod();
            String genericSignature = underlyingMethod.genericSignature();
            if (genericSignature == null) {
                return underlyingMethod.argumentTypeNames();
            }
            String[] parameterTypes = Signature.getParameterTypes((String)genericSignature);
            ArrayList<String> argumentTypeNames = new ArrayList<String>();
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                argumentTypeNames.add(Signature.toString((String)parameterType).replace('/', '.'));
                ++n2;
            }
            return argumentTypeNames;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_argument_type_names, e.toString()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                return this.fLocation.lineNumber();
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_line_number, e.toString()), e);
                }
            }
        }
        return -1;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepOver();
        } else {
            ((JDIThread)this.getThread()).stepToFrame(this);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepReturn();
        } else {
            List<IJavaStackFrame> frames = ((JDIThread)this.getThread()).computeStackFrames();
            int index = frames.indexOf(this);
            if (index >= 0 && index < frames.size() - 1) {
                IStackFrame nextFrame = frames.get(index + 1);
                ((JDIThread)this.getThread()).stepToFrame(nextFrame);
            }
        }
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    protected void updateVariables() throws DebugException {
        JDILocalVariable local;
        if (this.fVariables == null) {
            return;
        }
        if (!this.fVariables.isEmpty() && this.fVariables.get(0) instanceof JDIReturnValueVariable) {
            this.fVariables.remove(0);
        }
        Method method = this.getUnderlyingMethod();
        int index = 0;
        if (!method.isStatic()) {
            ObjectReference thisObject = this.getUnderlyingThisObject();
            JDIThisVariable oldThisObject = null;
            if (!this.fVariables.isEmpty() && this.fVariables.get(0) instanceof JDIThisVariable) {
                oldThisObject = (JDIThisVariable)this.fVariables.get(0);
            }
            if (thisObject == null && oldThisObject != null) {
                this.fVariables.remove(0);
                index = 0;
            } else if (oldThisObject == null && thisObject != null) {
                oldThisObject = new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), thisObject);
                this.fVariables.add(0, oldThisObject);
                index = 1;
            } else if (oldThisObject != null) {
                if (!oldThisObject.retrieveValue().equals(thisObject)) {
                    this.fVariables.remove(0);
                    this.fVariables.add(0, new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), thisObject));
                }
                index = 1;
            }
        }
        List locals = null;
        try {
            locals = this.getUnderlyingStackFrame().visibleVariables();
        }
        catch (AbsentInformationException absentInformationException) {
            locals = Collections.EMPTY_LIST;
        }
        catch (NativeMethodException nativeMethodException) {
            locals = Collections.EMPTY_LIST;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_visible_variables, e.toString()), e);
            return;
        }
        int localIndex = -1;
        while (index < this.fVariables.size()) {
            IJavaVariable var = this.fVariables.get(index);
            if (var instanceof JDILocalVariable) {
                local = (JDILocalVariable)this.fVariables.get(index);
                localIndex = locals.indexOf(local.getLocal());
                if (localIndex >= 0) {
                    local.setLocal((LocalVariable)locals.get(localIndex));
                    locals.remove(localIndex);
                    ++index;
                    continue;
                }
                this.fVariables.remove(index);
                continue;
            }
            ++index;
        }
        Iterator newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            local = new JDILocalVariable(this, (LocalVariable)newOnes.next());
            this.fVariables.add(local);
        }
        this.addStepReturnValue(this.fVariables);
    }

    public boolean canDropToFrame() {
        return this.supportsDropToFrame();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean supportsDropToFrame() {
        JDIThread thread = (JDIThread)this.getThread();
        JDIDebugTarget target = (JDIDebugTarget)thread.getDebugTarget();
        try {
            if (!target.isAvailable()) return false;
            if (!thread.isSuspended()) return false;
            if (thread.isTerminated()) return false;
            if (thread.isInvokingMethod()) {
                return false;
            }
            boolean j9Support = false;
            boolean jdkSupport = target.canPopFrames();
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm == null) {
                return false;
            }
            try {
                j9Support = thread.getUnderlyingThread() instanceof ThreadReference && ((VirtualMachine)((Object)vm)).canDoReturn();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                j9Support = false;
            }
            if (!jdkSupport) {
                if (!j9Support) return false;
            }
            List<IJavaStackFrame> frames = thread.computeStackFrames();
            if (jdkSupport && frames.size() > 0 && frames.get(frames.size() - 1) == this) {
                return false;
            }
            int index = 0;
            JDIStackFrame frame = null;
            do {
                if (index >= frames.size()) {
                    return false;
                }
                frame = (JDIStackFrame)frames.get(index);
                ++index;
                if (!frame.isNative()) continue;
                return false;
            } while (!frame.equals(this));
            if (!jdkSupport) return true;
            if (index >= frames.size()) return true;
            if (!((JDIStackFrame)frames.get(index)).isNative()) return true;
            return false;
        }
        catch (DebugException e) {
            if (e.getStatus().getException() instanceof IncompatibleThreadStateException) return false;
            if (e.getStatus().getCode() == 100) {
                return false;
            }
            this.logError((Exception)((Object)e));
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        catch (RuntimeException e) {
            this.internalError(e);
        }
        return false;
    }

    public void dropToFrame() throws DebugException {
        if (this.supportsDropToFrame()) {
            ((JDIThread)this.getThread()).dropToFrame(this);
        } else {
            this.notSupported(JDIDebugModelMessages.JDIStackFrame_Drop_to_frame_not_supported);
        }
    }

    public void popFrame() throws DebugException {
        if (this.supportsDropToFrame()) {
            ((JDIThread)this.getThread()).popFrame(this);
        } else {
            this.notSupported(JDIDebugModelMessages.JDIStackFrame_pop_frame_not_supported);
        }
    }

    @Override
    public IJavaVariable findVariable(String varName) throws DebugException {
        if (this.isNative()) {
            return null;
        }
        IVariable[] variables = this.getVariables();
        ArrayList<IJavaVariable> possibleMatches = new ArrayList<IJavaVariable>();
        IJavaVariable thisVariable = null;
        IVariable[] iVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable iVariable = iVariableArray[n2];
            IJavaVariable var = (IJavaVariable)iVariable;
            if (var.getName().equals(varName)) {
                possibleMatches.add(var);
            }
            if (var instanceof JDIThisVariable) {
                thisVariable = var;
            }
            if (var instanceof JDILambdaVariable) {
                IVariable[] lvars;
                JDILambdaVariable lambda = (JDILambdaVariable)var;
                JDIObjectValue ov = (JDIObjectValue)lambda.getValue();
                IVariable[] iVariableArray2 = lvars = ov.getVariables();
                int n3 = lvars.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVariable lv = iVariableArray2[n4];
                    String name = lv.getName();
                    if (name.startsWith(SYNTHETIC_OUTER_LOCAL_PREFIX) && (String.valueOf(SYNTHETIC_OUTER_LOCAL_PREFIX) + varName).equals(name)) {
                        possibleMatches.add((IJavaVariable)lv);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        for (IJavaVariable iJavaVariable : possibleMatches) {
            if (!(iJavaVariable instanceof JDILocalVariable)) continue;
            return iJavaVariable;
        }
        if (possibleMatches.size() > 0) {
            return (IJavaVariable)possibleMatches.get(0);
        }
        if (thisVariable != null) {
            IVariable[] iVariableArray3;
            IVariable[] iVariableArray4 = iVariableArray3 = thisVariable.getValue().getVariables();
            int n5 = iVariableArray3.length;
            n = 0;
            while (n < n5) {
                IVariable element = iVariableArray4[n];
                IJavaVariable var = (IJavaVariable)element;
                if (var.getName().equals(varName)) {
                    return var;
                }
                ++n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LocalVariable> getUnderlyingVisibleVariables() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            List<LocalVariable> variables = Collections.EMPTY_LIST;
            try {
                variables = this.getUnderlyingStackFrame().visibleVariables();
            }
            catch (AbsentInformationException absentInformationException) {
                this.setLocalsAvailable(false);
            }
            catch (NativeMethodException nativeMethodException) {
                this.setLocalsAvailable(false);
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_visible_variables_2, e.toString()), e);
            }
            return variables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectReference getUnderlyingThisObject() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            block6: {
                if (this.fStackFrame != null && this.fThisObject != null || this.isStatic() || this.getUnderlyingStackFrame() == null) break block6;
                try {
                    this.fThisObject = this.getUnderlyingStackFrame().thisObject();
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_this, e.toString()), e);
                    return null;
                }
            }
            return this.fThisObject;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IJavaStackFrame.class || adapter == IJavaModifiers.class) {
            return (T)this;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getSignature() throws DebugException {
        try {
            return this.getUnderlyingMethod().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_method_signature, e.toString()), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeclaringTypeName() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                if (this.isObsolete()) {
                    return JDIDebugModelMessages.JDIStackFrame__unknown_declaring_type__1;
                }
                return JDIReferenceType.getGenericName(this.getUnderlyingMethod().declaringType());
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_declaring_type, e.toString()), e);
                }
                return JDIDebugModelMessages.JDIStackFrame__unknown_declaring_type__1;
            }
        }
    }

    @Override
    public String getReceivingTypeName() throws DebugException {
        if (this.fStackFrame == null || this.fReceivingTypeName == null) {
            try {
                ObjectReference thisObject;
                this.fReceivingTypeName = this.isObsolete() ? JDIDebugModelMessages.JDIStackFrame__unknown_receiving_type__2 : ((thisObject = this.getUnderlyingThisObject()) == null ? this.getDeclaringTypeName() : JDIReferenceType.getGenericName(thisObject.referenceType()));
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_receiving_type, e.toString()), e);
                }
                return JDIDebugModelMessages.JDIStackFrame__unknown_receiving_type__2;
            }
        }
        return this.fReceivingTypeName;
    }

    @Override
    public String getMethodName() throws DebugException {
        try {
            return this.getUnderlyingMethod().name();
        }
        catch (RuntimeException e) {
            if (this.getThread().isSuspended()) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_method_name, e.toString()), e);
            }
            return JDIDebugModelMessages.JDIStackFrame__unknown_method__1;
        }
    }

    @Override
    public boolean isNative() throws DebugException {
        return this.getUnderlyingMethod().isNative();
    }

    @Override
    public boolean isConstructor() throws DebugException {
        return this.getUnderlyingMethod().isConstructor();
    }

    @Override
    public boolean isStaticInitializer() throws DebugException {
        return this.getUnderlyingMethod().isStaticInitializer();
    }

    @Override
    public boolean isFinal() throws DebugException {
        return this.getUnderlyingMethod().isFinal();
    }

    @Override
    public boolean isSynchronized() throws DebugException {
        return this.getUnderlyingMethod().isSynchronized();
    }

    @Override
    public boolean isSynthetic() throws DebugException {
        return this.getUnderlyingMethod().isSynthetic();
    }

    @Override
    public boolean isPublic() throws DebugException {
        return this.getUnderlyingMethod().isPublic();
    }

    @Override
    public boolean isPrivate() throws DebugException {
        return this.getUnderlyingMethod().isPrivate();
    }

    @Override
    public boolean isProtected() throws DebugException {
        return this.getUnderlyingMethod().isProtected();
    }

    @Override
    public boolean isPackagePrivate() throws DebugException {
        return this.getUnderlyingMethod().isPackagePrivate();
    }

    @Override
    public boolean isStatic() throws DebugException {
        return this.getUnderlyingMethod().isStatic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourceName() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            return this.getSourceName(this.fLocation);
        }
    }

    private String getSourceName(Location location) throws DebugException {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
        catch (NativeMethodException nativeMethodException) {
            return null;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_source_name, e.toString()), e);
            return null;
        }
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    public void setOutOfSynch(boolean outOfSynch) {
        this.fIsOutOfSynch = outOfSynch;
    }

    @Override
    public boolean isOutOfSynch() throws DebugException {
        JDIDebugTarget target;
        if (this.fIsOutOfSynch) {
            return true;
        }
        return this.getThread().isSuspended() && (target = (JDIDebugTarget)this.getDebugTarget()).hasHCROccurred() && target.isOutOfSynch(this.getUnderlyingMethod().declaringType().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObsolete() {
        if (!JDIDebugPlugin.isJdiVersionGreaterThanOrEqual(new int[]{1, 4}) || !((JDIDebugTarget)this.getDebugTarget()).hasHCROccurred()) {
            return false;
        }
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.getThread().isSuspended()) {
                return this.getUnderlyingMethod().isObsolete();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists() {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            return this.fDepth != -1;
        }
    }

    public boolean canTerminate() {
        return this.exists() && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StackFrame getUnderlyingStackFrame() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.fStackFrame == null) {
                if (this.fDepth == -1) {
                    throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 130, JDIDebugModelMessages.JDIStackFrame_25, null));
                }
                if (this.fThread.isSuspended()) {
                    this.fThread.computeStackFrames();
                    if (this.fDepth == -1) {
                        this.fThread.computeStackFrames();
                        if (this.fDepth == -1) {
                            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 130, JDIDebugModelMessages.JDIStackFrame_25, null));
                        }
                    }
                } else {
                    throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 100, JDIDebugModelMessages.JDIStackFrame_25, null));
                }
            }
            return this.fStackFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUnderlyingStackFrame(StackFrame frame) {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            this.fStackFrame = frame;
            if (frame == null) {
                this.fRefreshVariables = true;
            }
        }
    }

    protected void setThread(JDIThread thread) {
        this.fThread = thread;
    }

    protected void setVariables(List<IJavaVariable> variables) {
        this.fVariables = variables;
    }

    @Override
    public IJavaVariable[] getLocalVariables() throws DebugException {
        List<LocalVariable> list = this.getUnderlyingVisibleVariables();
        IJavaVariable[] locals = new IJavaVariable[list.size()];
        int i = 0;
        while (i < list.size()) {
            locals[i] = new JDILocalVariable(this, list.get(i));
            ++i;
        }
        return locals;
    }

    @Override
    public IJavaObject getThis() throws DebugException {
        ObjectReference thisObject;
        IJavaObject receiver = null;
        if (!this.isStatic() && !this.isNative() && (thisObject = this.getUnderlyingThisObject()) != null) {
            receiver = (IJavaObject)((Object)JDIValue.createValue((JDIDebugTarget)this.getDebugTarget(), thisObject));
        }
        return receiver;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return new IRegisterGroup[0];
    }

    @Override
    public IJavaClassType getDeclaringType() throws DebugException {
        Method method = this.getUnderlyingMethod();
        try {
            ReferenceType type = method.declaringType();
            if (type instanceof ClassType) {
                return (IJavaClassType)((Object)JDIType.createType((JDIDebugTarget)this.getDebugTarget(), type));
            }
            this.targetRequestFailed(JDIDebugModelMessages.JDIStackFrame_0, null);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retreiving_declaring_type, e.toString()), e);
        }
        return null;
    }

    @Override
    public IJavaReferenceType getReferenceType() throws DebugException {
        Method method = this.getUnderlyingMethod();
        try {
            ReferenceType type = method.declaringType();
            return (IJavaReferenceType)((Object)JDIType.createType((JDIDebugTarget)this.getDebugTarget(), type));
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retreiving_declaring_type, e.toString()), e);
            return null;
        }
    }

    public int getCharEnd() {
        return -1;
    }

    public int getCharStart() {
        return -1;
    }

    private void clearCachedData() {
        this.fThisObject = null;
        this.fReceivingTypeName = null;
    }

    @Override
    public boolean wereLocalsAvailable() {
        return this.fLocalsAvailable;
    }

    private void setLocalsAvailable(boolean available) {
        if (available != this.fLocalsAvailable) {
            this.fLocalsAvailable = available;
            this.fireChangeEvent(256);
        }
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public boolean canStepWithFilters() {
        if (this.canStepInto()) {
            String[] filters = this.getJavaDebugTarget().getStepFilters();
            return filters != null && filters.length > 0;
        }
        return false;
    }

    public void stepWithFilters() throws DebugException {
        ((IJavaThread)this.getThread()).stepWithFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourcePath(String stratum) throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                return this.fLocation.sourcePath(stratum);
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_source_path, e.toString()), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourcePath() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                return this.fLocation.sourcePath();
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_source_path, e.toString()), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineNumber(String stratum) throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                return this.fLocation.lineNumber(stratum);
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_line_number, e.toString()), e);
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourceName(String stratum) throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            try {
                return this.fLocation.sourceName(stratum);
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (NativeMethodException nativeMethodException) {
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIStackFrame_exception_retrieving_source_name, e.toString()), e);
            }
        }
        return null;
    }

    @Override
    public boolean isVarArgs() throws DebugException {
        return this.getUnderlyingMethod().isVarArgs();
    }

    @Override
    public boolean canForceReturn() {
        block5: {
            if (this.getJavaDebugTarget().supportsForceReturn() && this.isSuspended()) {
                block6: {
                    try {
                        if (this.isNative()) break block5;
                        if (!this.isTopStackFrame()) break block6;
                        return true;
                    }
                    catch (DebugException debugException) {}
                }
                List<IJavaStackFrame> frames = this.fThread.computeStackFrames();
                int index = frames.indexOf(this);
                if (index > 0) {
                    JDIStackFrame prev = (JDIStackFrame)frames.get(index - 1);
                    return prev.canDropToFrame();
                }
            }
        }
        return false;
    }

    @Override
    public void forceReturn(IJavaValue value) throws DebugException {
        if (this.isTopStackFrame()) {
            this.fThread.forceReturn(value);
        } else {
            Method method = this.getUnderlyingMethod();
            try {
                ValueImpl.checkValue(((JDIValue)value).getUnderlyingValue(), method.returnType(), (VirtualMachineImpl)method.virtualMachine());
            }
            catch (InvalidTypeException e) {
                this.targetRequestFailed(JDIDebugModelMessages.JDIStackFrame_26, e);
            }
            catch (ClassNotLoadedException e) {
                this.targetRequestFailed(JDIDebugModelMessages.JDIThread_48, e);
            }
            List<IJavaStackFrame> frames = this.fThread.computeStackFrames();
            int index = frames.indexOf(this);
            if (index > 0) {
                JDIStackFrame prev = (JDIStackFrame)frames.get(index - 1);
                this.fThread.popFrame(prev);
                this.fThread.forceReturn(value);
            }
        }
    }

    public void setIsTop(boolean isTop) {
        this.fIsTop = isTop;
    }

    private static final class LambdaASTVisitor
    extends ASTVisitor {
        private final ObjectReference underlyingThisObject;
        private boolean methodIsStatic;
        private CompilationUnit cu;
        private int lineNo;

        private LambdaASTVisitor(boolean visitDocTags, ObjectReference underlyingThisObject, boolean methodIsStatic, CompilationUnit cu, int lineNo) {
            super(visitDocTags);
            this.underlyingThisObject = underlyingThisObject;
            this.methodIsStatic = methodIsStatic;
            this.cu = cu;
            this.lineNo = lineNo;
        }

        public boolean visit(LambdaExpression lambdaExpression) {
            block9: {
                int i;
                ListIterator<Field> listIterator;
                List<Field> allFields;
                IVariableBinding[] synVars;
                block8: {
                    if (this.lineNo < this.cu.getLineNumber(lambdaExpression.getStartPosition()) || this.lineNo > this.cu.getLineNumber(lambdaExpression.getStartPosition() + lambdaExpression.getLength())) {
                        return true;
                    }
                    IMethodBinding binding = lambdaExpression.resolveMethodBinding();
                    if (binding == null) {
                        return true;
                    }
                    synVars = binding.getSyntheticOuterLocals();
                    if (synVars == null || synVars.length == 0) {
                        return true;
                    }
                    allFields = this.underlyingThisObject.referenceType().fields();
                    listIterator = allFields.listIterator();
                    i = 0;
                    if (!this.methodIsStatic) break block8;
                    if (synVars.length != allFields.size()) break block9;
                    while (listIterator.hasNext()) {
                        FieldImpl field = (FieldImpl)listIterator.next();
                        String newName = synVars[i].getName();
                        FieldImpl newField = this.createRenamedCopy(field, newName);
                        listIterator.set(newField);
                        ++i;
                    }
                    break block9;
                }
                if (synVars.length + 1 == allFields.size()) {
                    while (listIterator.hasNext()) {
                        FieldImpl field = (FieldImpl)listIterator.next();
                        if (i == 0) {
                            listIterator.remove();
                        } else {
                            String newName = synVars[i - 1].getName();
                            FieldImpl newField = this.createRenamedCopy(field, newName);
                            listIterator.set(newField);
                        }
                        ++i;
                    }
                }
            }
            return true;
        }

        private FieldImpl createRenamedCopy(FieldImpl field, String newName) {
            return new FieldImpl((VirtualMachineImpl)field.virtualMachine(), (ReferenceTypeImpl)field.declaringType(), field.getFieldID(), newName, field.signature(), field.genericSignature(), field.modifiers());
        }
    }
}

