/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.gerrit;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class GerritUtil {
    public static final String REFS_FOR = "refs/for/";
    public static final String REFS_PUBLISH = "refs/publish/";
    public static final String REFS_DRAFTS = "refs/drafts/";

    public static boolean getCreateChangeId(Config config) {
        return config.getBoolean("gerrit", "createchangeid", false);
    }

    public static void setCreateChangeId(Config config) {
        config.setBoolean("gerrit", null, "createchangeid", true);
    }

    public static RemoteConfig findRemoteConfig(Config config, String remoteName) throws URISyntaxException {
        RemoteConfig remoteConfig = null;
        List allRemoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)config);
        for (RemoteConfig rc : allRemoteConfigs) {
            if (!rc.getName().equals(remoteName)) continue;
            remoteConfig = rc;
            break;
        }
        return remoteConfig;
    }

    public static void configurePushURI(RemoteConfig remoteConfig, URIish pushURI) {
        ArrayList pushURIs = new ArrayList(remoteConfig.getPushURIs());
        for (URIish urIish : pushURIs) {
            remoteConfig.removePushURI(urIish);
        }
        remoteConfig.addPushURI(pushURI);
    }

    public static void configurePushRefSpec(RemoteConfig remoteConfig, String gerritBranch) {
        ArrayList pushRefSpecs = new ArrayList(remoteConfig.getPushRefSpecs());
        for (RefSpec refSpec : pushRefSpecs) {
            remoteConfig.removePushRefSpec(refSpec);
        }
        remoteConfig.addPushRefSpec(new RefSpec("HEAD:refs/for/" + gerritBranch));
    }

    public static boolean configureFetchNotes(RemoteConfig remoteConfig) {
        String notesRef = "refs/notes/*";
        List fetchRefSpecs = remoteConfig.getFetchRefSpecs();
        for (RefSpec refSpec : fetchRefSpecs) {
            if (!refSpec.matchSource(notesRef)) continue;
            return false;
        }
        remoteConfig.addFetchRefSpec(new RefSpec(String.valueOf(notesRef) + ':' + notesRef));
        return true;
    }

    public static boolean isGerritPush(RemoteConfig rc) {
        for (RefSpec pushSpec : rc.getPushRefSpecs()) {
            String destination = pushSpec.getDestination();
            if (destination == null || !destination.startsWith(REFS_FOR) && !destination.startsWith(REFS_PUBLISH) && !destination.startsWith(REFS_DRAFTS)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGerritFetch(RemoteConfig rc) {
        for (RefSpec fetchSpec : rc.getFetchRefSpecs()) {
            String source = fetchSpec.getSource();
            String destination = fetchSpec.getDestination();
            if (source == null || destination == null || !source.startsWith("refs/notes/") || !destination.startsWith("refs/notes/")) continue;
            return true;
        }
        return false;
    }

    public static void tryToAutoConfigureForGerrit(@NonNull Repository repository) {
        if (repository.isBare()) {
            return;
        }
        StoredConfig config = repository.getConfig();
        boolean isGerrit = false;
        boolean changed = false;
        try {
            for (RemoteConfig remote : RemoteConfig.getAllRemoteConfigs((Config)config)) {
                if (!GerritUtil.isGerritPush(remote)) continue;
                isGerrit = true;
                if (!GerritUtil.configureFetchNotes(remote)) continue;
                changed = true;
                remote.update((Config)config);
            }
        }
        catch (URISyntaxException remote) {
            // empty catch block
        }
        if (isGerrit) {
            if (config.getString("gerrit", null, "createchangeid") == null) {
                GerritUtil.setCreateChangeId((Config)config);
                changed = true;
            }
            if (changed) {
                try {
                    config.save();
                }
                catch (IOException e) {
                    Activator.logError(MessageFormat.format(CoreText.GerritUtil_ConfigSaveError, repository.getDirectory()), e);
                }
            }
        }
    }

    public static void tryToAutoConfigureForGerrit(@Nullable File repositoryDir) {
        if (repositoryDir != null) {
            try {
                Repository repository = RepositoryCache.getInstance().lookupRepository(repositoryDir);
                if (repository != null) {
                    GerritUtil.tryToAutoConfigureForGerrit(repository);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

