/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jgit.lib.Repository;

public class RepositoryGroupNode
extends RepositoryTreeNode<RepositoryGroup> {
    private RepositoryGroup group;

    public RepositoryGroupNode(RepositoryGroup group) {
        super(null, RepositoryTreeNodeType.REPOGROUP, null, group);
        this.group = group;
    }

    public boolean hasChildren() {
        return this.group.hasRepositories();
    }

    public Collection<? extends Repository> getRepositories() {
        LinkedHashSet<Repository> result = new LinkedHashSet<Repository>();
        RepositoryCache repositoryCache = RepositoryCache.getInstance();
        List<File> repoDirs = ((RepositoryGroup)this.getObject()).getRepositoryDirectories();
        for (File repoDir : repoDirs) {
            Repository repo = null;
            try {
                repo = repositoryCache.lookupRepository(repoDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (repo == null) continue;
            result.add(repo);
        }
        return result;
    }
}

