/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder.event;

import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.event.DocumentBuilderEvent;

public class BeginHeadingEvent
extends DocumentBuilderEvent {
    private final int level;
    private final Attributes attributes;

    public BeginHeadingEvent(int level, Attributes attributes) {
        this.level = level;
        this.attributes = Objects.requireNonNull(attributes, "Must provide attributes").clone();
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.beginHeading(this.level, this.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BeginHeadingEvent)) {
            return false;
        }
        BeginHeadingEvent other = (BeginHeadingEvent)obj;
        return other.level == this.level;
    }

    public String toString() {
        return String.format("beginHeading(%s)", this.level);
    }
}

