/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.sourcelookup;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.resources.ResourceLookup;
import org.eclipse.corrosion.sourcelookup.CargoProjectSourceContainer;
import org.eclipse.corrosion.sourcelookup.ICargoSourceLocation;
import org.eclipse.corrosion.sourcelookup.IProjectSourceLocation;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CargoSourceUtils {
    private static final String NAME_COMMON_SOURCE_LOCATIONS = "commonSourceLocations";
    private static final String NAME_SOURCE_LOCATION = "sourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";

    public static String getCommonSourceLocationsMemento(ICargoSourceLocation[] locations) {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(NAME_COMMON_SOURCE_LOCATIONS);
            document.appendChild(element);
            CargoSourceUtils.saveSourceLocations(document, element, locations);
            return CargoSourceUtils.serializeDocument(document, true);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        CorrosionPlugin.logError((IStatus)new Status(4, "org.eclipse.corrosion", 0, "Error saving common source settings.", (Throwable)ex));
        return null;
    }

    private static void saveSourceLocations(Document doc, Element node, ICargoSourceLocation[] locations) {
        ICargoSourceLocation[] iCargoSourceLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                ICargoSourceLocation location = iCargoSourceLocationArray[n2];
                Element child = doc.createElement(NAME_SOURCE_LOCATION);
                child.setAttribute(ATTR_CLASS, location.getClass().getName());
                try {
                    child.setAttribute(ATTR_MEMENTO, location.getMemento());
                }
                catch (CoreException e) {
                    CorrosionPlugin.logError(e);
                    break block3;
                }
                node.appendChild(child);
            }
            ++n2;
        }
    }

    public static ICargoSourceLocation[] getCommonSourceLocationsFromMemento(String memento) {
        ICargoSourceLocation[] result = new ICargoSourceLocation[]{};
        if (memento != null && !memento.isEmpty()) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader reader = new StringReader(memento);
                InputSource source = new InputSource(reader);
                Element root = parser.parse(source).getDocumentElement();
                if (root.getNodeName().equalsIgnoreCase(NAME_COMMON_SOURCE_LOCATIONS)) {
                    result = CargoSourceUtils.initializeSourceLocations(root);
                }
            }
            catch (ParserConfigurationException e) {
                CorrosionPlugin.logError((IStatus)new Status(4, "org.eclipse.corrosion", 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (SAXException e) {
                CorrosionPlugin.logError((IStatus)new Status(4, "org.eclipse.corrosion", 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (IOException e) {
                CorrosionPlugin.logError((IStatus)new Status(4, "org.eclipse.corrosion", 0, "Error initializing common source settings.", (Throwable)e));
            }
        }
        return result;
    }

    public static ICargoSourceLocation[] initializeSourceLocations(Element root) {
        LinkedList<ICargoSourceLocation> sourceLocations = new LinkedList<ICargoSourceLocation>();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block10: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(NAME_SOURCE_LOCATION)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (className == null || className.trim().isEmpty()) {
                        CorrosionPlugin.logError("Unable to restore common source locations - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = CorrosionPlugin.getDefault().getBundle().loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            CorrosionPlugin.logError(MessageFormat.format("Unable to restore source location - class not found {0}", className));
                            break block10;
                        }
                        ICargoSourceLocation location = null;
                        try {
                            location = (ICargoSourceLocation)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            CorrosionPlugin.logError("Unable to restore source location: " + e.getMessage());
                            break block10;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            CorrosionPlugin.logError("Unable to restore source location: " + e.getMessage());
                        }
                    }
                }
            }
            ++i;
        }
        return sourceLocations.toArray(new ICargoSourceLocation[sourceLocations.size()]);
    }

    public static ISourceContainer[] convertSourceLocations(ICargoSourceLocation[] locations) {
        ArrayList<CargoProjectSourceContainer> containers = new ArrayList<CargoProjectSourceContainer>(locations.length);
        ICargoSourceLocation[] iCargoSourceLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ICargoSourceLocation location = iCargoSourceLocationArray[n2];
            if (location instanceof IProjectSourceLocation) {
                containers.add(new CargoProjectSourceContainer(((IProjectSourceLocation)location).getProject(), false));
            }
            ++n2;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    public static IProject getLaunchConfigurationProject(ISourceLookupDirector director) {
        String name = CargoSourceUtils.getLaunchConfigurationProjectName(director);
        return name != null ? ResourcesPlugin.getWorkspace().getRoot().getProject(name) : null;
    }

    public static String getLaunchConfigurationProjectName(ISourceLookupDirector director) {
        ILaunchConfiguration config = director.getLaunchConfiguration();
        if (config != null) {
            try {
                String name = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                if (!name.isEmpty()) {
                    return name;
                }
            }
            catch (CoreException e) {
                CorrosionPlugin.logError(e);
            }
        }
        return null;
    }

    public static IProject[] getAllReferencedProjects(IProject project) throws CoreException {
        HashSet<IProject> all = new HashSet<IProject>();
        CargoSourceUtils.getAllReferencedProjects(all, project);
        return all.toArray(new IProject[all.size()]);
    }

    private static void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        IProject[] iProjectArray = project.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            if (!all.contains(ref) && ref.exists() && ref.isOpen()) {
                all.add(ref);
                CargoSourceUtils.getAllReferencedProjects(all, ref);
            }
            ++n2;
        }
    }

    public static String serializeDocument(Document doc, boolean indent) throws TransformerException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString(StandardCharsets.UTF_8);
    }

    public static Object[] findSourceElements(File file, ISourceLookupDirector director) {
        Object[] wfiles = ResourceLookup.findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
        IProject lcProject = null;
        if (director != null) {
            lcProject = CargoSourceUtils.getLaunchConfigurationProject(director);
        }
        if (wfiles.length > 0) {
            ResourceLookup.sortFilesByRelevance((IFile[])wfiles, lcProject);
            return wfiles;
        }
        try {
            wfiles = ResourceLookup.findFilesForLocation((IPath)new Path(file.getCanonicalPath()));
            if (wfiles.length > 0) {
                ResourceLookup.sortFilesByRelevance((IFile[])wfiles, lcProject);
                return wfiles;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new LocalFileStorage[]{new LocalFileStorage(file)};
    }
}

