/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.ui;

import java.util.function.Supplier;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.ui.InputComponent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class OptionalDefaultInputComponent
extends InputComponent {
    private Button defaultButton;
    private Supplier<String> defaultValueGenerator;

    public OptionalDefaultInputComponent(Composite container, String labelString, ModifyListener editListener, Supplier<String> defaultValueGenerator) {
        super(container, labelString, editListener);
        this.defaultValueGenerator = defaultValueGenerator;
    }

    @Override
    public void createComponent() {
        this.defaultButton = new Button(this.container, 32);
        this.defaultButton.setText(Messages.LaunchUI_useDefault);
        this.defaultButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        this.defaultButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateSelection(this.defaultButton.getSelection())));
        super.createComponent();
        GridData wdLabelData = this.getLabelGridData();
        wdLabelData.horizontalIndent = 25;
        this.setLabelGridData(wdLabelData);
        this.updateSelection(true);
    }

    public void updateSelection(boolean newSelection) {
        this.defaultButton.setSelection(newSelection);
        if (newSelection) {
            this.text.setText(this.defaultValueGenerator.get());
        }
        this.setEnabled(!newSelection);
    }

    @Override
    public void createVariableSelection() {
        super.createVariableSelection();
        this.variableButton.setEnabled(!this.defaultButton.getSelection());
    }

    @Override
    protected void createSelectionButton() {
        super.createSelectionButton();
        this.browseButton.setEnabled(!this.defaultButton.getSelection());
    }

    public boolean getSelection() {
        return this.defaultButton.getSelection();
    }
}

