/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.twiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.twiki.TWikiLanguage;

public class TableOfContentsBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("\\s*\\%TOC\\%\\s*");
    private int blockLineNumber = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineNumber++ > 0) {
            this.setClosed(true);
            return 0;
        }
        if (!this.getMarkupLanguage().isFilterGenerativeContents()) {
            OutlineParser outlineParser = new OutlineParser((MarkupLanguage)new TWikiLanguage());
            OutlineItem rootItem = outlineParser.parse(this.state.getMarkupContent());
            this.emitToc(rootItem);
        }
        return -1;
    }

    private void emitToc(OutlineItem item) {
        if (item.getChildren().isEmpty()) {
            return;
        }
        Attributes nullAttributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        for (OutlineItem child : item.getChildren()) {
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, nullAttributes);
            this.builder.link('#' + child.getId(), child.getLabel());
            this.emitToc(child);
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && !this.getMarkupLanguage().isFilterGenerativeContents()) {
            this.matcher = startPattern.matcher(line);
            this.blockLineNumber = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

