/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizeWizardPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class GitSynchronizeWizard
extends Wizard {
    private GitSynchronizeWizardPage page;

    public GitSynchronizeWizard() {
        this.setWindowTitle(UIText.GitSynchronizeWizard_synchronize);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_SYNCHRONIZE);
    }

    public void addPages() {
        this.page = new GitSynchronizeWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        GitSynchronizeDataSet gsdSet = new GitSynchronizeDataSet(this.page.forceFetch());
        Map<Repository, String> branches = this.page.getSelectedBranches();
        boolean shouldIncludeLocal = this.page.shouldIncludeLocal();
        for (Map.Entry<Repository, String> branchesEntry : branches.entrySet()) {
            try {
                Repository repo = branchesEntry.getKey();
                GitSynchronizeData data = new GitSynchronizeData(repo, "HEAD", branchesEntry.getValue(), shouldIncludeLocal);
                Set<IResource> resources = this.getSelectedResources(repo);
                if (resources != null && resources.size() > 0) {
                    data.setIncludedResources(resources);
                }
                gsdSet.add(data);
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        Set<IProject> selectedProjects = this.page.getSelectedProjects();
        GitModelSynchronize.launch(gsdSet, selectedProjects.toArray(new IResource[0]));
        return true;
    }

    private Set<IResource> getSelectedResources(Repository repo) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            HashSet<IResource> result = new HashSet<IResource>();
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() == 0) {
                return null;
            }
            File workTree = repo.getWorkTree();
            Object[] objectArray = sel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository selRepo;
                RepositoryMapping mapping;
                int type;
                IResource res;
                Object o = objectArray[n2];
                if (o != null && (res = AdapterUtils.adaptToAnyResource((Object)o)) != null && (type = res.getType()) == 2 && (mapping = RepositoryMapping.getMapping((IResource)res)) != null && workTree.equals((selRepo = mapping.getRepository()).getWorkTree())) {
                    result.add(res);
                }
                ++n2;
            }
            return result;
        }
        return null;
    }
}

