/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.css;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.properties.Gradient;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class GradientCanvasPropertyHandler
extends AbstractCSSPropertySWTHandler {
    public static final String BACKGROUND_COLOR = "background-color";
    public static final String BACKGROUND_BASE_COLOR = "background-base-color";
    public static final String H_BOTTOM_KEYLINE_2 = "h-bottom-keyline-2-color";
    public static final String H_BOTTOM_KEYLINE_1 = "h-bottom-keyline-1-color";

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof GradientCanvas)) {
            return;
        }
        GradientCanvas canvas = (GradientCanvas)control;
        if (BACKGROUND_COLOR.equals(property)) {
            if (value.getCssValueType() == 2) {
                Gradient grad = (Gradient)engine.convert(value, Gradient.class, (Object)canvas.getDisplay());
                if (grad == null) {
                    canvas.setBackgroundGradient(null, null, false);
                    return;
                }
                List values = grad.getValues();
                ArrayList<Color> colors = new ArrayList<Color>(values.size());
                for (CSSPrimitiveValue cssValue : values) {
                    if (cssValue == null || cssValue.getCssValueType() != 1) continue;
                    Color color = (Color)engine.convert((CSSValue)cssValue, Color.class, (Object)canvas.getDisplay());
                    colors.add(color);
                }
                if (colors.size() > 0) {
                    List list = grad.getPercents();
                    int[] percents = new int[list.size()];
                    int i = 0;
                    while (i < percents.length) {
                        percents[i] = (Integer)list.get(i);
                        ++i;
                    }
                    canvas.setBackgroundGradient(colors.toArray(new Color[0]), percents, grad.getVerticalGradient());
                } else {
                    canvas.setBackgroundGradient(null, null, false);
                }
            } else if (value.getCssValueType() == 1) {
                Color color = (Color)engine.convert(value, Color.class, (Object)canvas.getDisplay());
                canvas.setBackgroundGradient(null, null, false);
                canvas.setBackground(color);
            }
        } else if ((H_BOTTOM_KEYLINE_1.equals(property) || H_BOTTOM_KEYLINE_2.equals(property) || BACKGROUND_BASE_COLOR.equals(property)) && value.getCssValueType() == 1) {
            Color color = (Color)engine.convert(value, Color.class, (Object)canvas.getDisplay());
            if (H_BOTTOM_KEYLINE_1.equals(property)) {
                canvas.putColor(GradientCanvas.H_BOTTOM_KEYLINE1, color);
            } else if (H_BOTTOM_KEYLINE_2.equals(property)) {
                canvas.putColor(GradientCanvas.H_BOTTOM_KEYLINE2, color);
            } else {
                canvas.setBackground(color);
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

