/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.validation;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.textile.core.validation.Messages;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

public class BlockWhitespaceRule
extends ValidationRule {
    private static final Pattern pattern = Pattern.compile("((?:bc|bq|pre|table|p)(?:\\.){1,2})(.)?", 8);

    public ValidationProblem findProblem(String markup, int offset, int length) {
        Matcher matcher = pattern.matcher(markup);
        if (offset > 0) {
            matcher.region(offset, offset + length);
        }
        while (matcher.find()) {
            String followingCharacter;
            int start = matcher.start();
            boolean startOfLine = false;
            if (start == 0) {
                startOfLine = true;
            } else {
                char c = markup.charAt(start - 1);
                if (c == '\r' || c == '\n') {
                    startOfLine = true;
                }
            }
            if (!startOfLine || (followingCharacter = matcher.group(2)) != null && followingCharacter.equals(" ")) continue;
            int problemLength = matcher.end(1) - start;
            String matched = matcher.group(1);
            return new ValidationProblem(ValidationProblem.Severity.WARNING, MessageFormat.format(Messages.getString("BlockWhitespaceRule.2"), matched), start, problemLength);
        }
        return null;
    }
}

