/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.dual;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.workspace.dual.Messages;
import org.eclipse.dirigible.ide.workspace.dual.RepositoryDataStore;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.ServiceManager;

public class DownloadProjectServiceHandler
implements ServiceHandler {
    private static final String ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION = Messages.DownloadProjectServiceHandler_ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION;
    static final String SERVICE_HANDLER_ID = "org.eclipse.dirigible.ide.workspace.wizard.project.export.DownloadProjectServiceHandler";
    private static final Logger logger = Logger.getLogger(DownloadProjectServiceHandler.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] download;
        String fileName = request.getParameter("filename");
        try {
            download = RepositoryDataStore.getByteArrayData(fileName);
            response.setContentType("application/zip");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            download = (String.valueOf(ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION) + fileName).getBytes();
            response.setContentType("text/plain");
            fileName = "error.txt";
        }
        response.setContentLength(download.length);
        String contentDisposition = "attachment; filename=\"" + fileName + "\"";
        response.setHeader("Content-Disposition", contentDisposition);
        response.getOutputStream().write(download);
    }

    public static String getUrl(String token) {
        ServiceManager manager = RWT.getServiceManager();
        String rootURL = manager.getServiceHandlerUrl(SERVICE_HANDLER_ID);
        StringBuffer url = new StringBuffer();
        url.append(rootURL);
        url.append("&");
        url.append("filename").append("=").append(token).append(".zip");
        int relativeIndex = url.lastIndexOf("/");
        if (relativeIndex > -1) {
            url.delete(0, relativeIndex + 1);
        }
        return RWT.getResponse().encodeURL(url.toString());
    }
}

