/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ParameterNode
extends ValueNode {
    private int parameterNumber;
    private DataTypeDescriptor[] userParameterTypes;
    private DataValueDescriptor defaultValue;
    private JSQLType jsqlType;
    private int orderableVariantType = 2;
    private ValueNode returnOutputParameter;
    private ValueNode valToGenerate;

    public void init(Object object, Object object2) {
        this.defaultValue = (DataValueDescriptor)object2;
        this.parameterNumber = (Integer)object;
    }

    int getParameterNumber() {
        return this.parameterNumber;
    }

    void setDescriptors(DataTypeDescriptor[] dataTypeDescriptorArray) {
        this.userParameterTypes = dataTypeDescriptorArray;
    }

    public void setType(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        dataTypeDescriptor = dataTypeDescriptor.getNullabilityType(true);
        if (this.userParameterTypes != null) {
            this.userParameterTypes[this.parameterNumber] = dataTypeDescriptor;
        }
        super.setType(dataTypeDescriptor);
        if (this.getJSQLType() == null) {
            this.setJSQLType(new JSQLType(dataTypeDescriptor));
        }
    }

    public void setReturnOutputParam(ValueNode valueNode) {
        this.returnOutputParameter = valueNode;
    }

    public boolean isReturnOutputParam() {
        return this.returnOutputParameter != null;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.checkReliability("?", 8);
        return this;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        return true;
    }

    protected int getOrderableVariantType() {
        return this.orderableVariantType;
    }

    void setOrderableVariantType(int n) {
        this.orderableVariantType = n;
    }

    public void setJSQLType(JSQLType jSQLType) {
        this.jsqlType = jSQLType;
    }

    public JSQLType getJSQLType() {
        return this.jsqlType;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.valToGenerate != null) {
            this.valToGenerate.generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        DataTypeDescriptor dataTypeDescriptor = this.getTypeServices();
        if (dataTypeDescriptor != null && dataTypeDescriptor.getTypeId().isXMLTypeId()) {
            throw StandardException.newException("42Z70");
        }
        methodBuilder.pushThis();
        methodBuilder.push(this.parameterNumber);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        switch (dataTypeDescriptor.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                methodBuilder.dup();
                methodBuilder.push(dataTypeDescriptor.getMaximumWidth());
                methodBuilder.callMethod((short)185, null, "checkHostVariable", "void", 1);
                break;
            }
        }
        methodBuilder.cast(this.getTypeCompiler().interfaceName());
    }

    public TypeId getTypeId() throws StandardException {
        return this.returnOutputParameter != null ? this.returnOutputParameter.getTypeId() : super.getTypeId();
    }

    public static void generateParameterValueSet(ExpressionClassBuilder expressionClassBuilder, int n, Vector vector) throws StandardException {
        if (n > 0) {
            MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
            boolean bl = ((ParameterNode)vector.get(0)).isReturnOutputParam();
            methodBuilder.pushThis();
            methodBuilder.push(n);
            methodBuilder.push(bl);
            methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "setParameterValueSet", "void", 2);
            MethodBuilder methodBuilder2 = expressionClassBuilder.getExecuteMethod();
            methodBuilder2.pushThis();
            methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "throwIfMissingParms", "void", 0);
        }
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public boolean requiresTypeFromContext() {
        return true;
    }

    public boolean isParameterNode() {
        return true;
    }

    protected boolean isEquivalent(ValueNode valueNode) {
        return false;
    }

    protected void setValueToGenerate(ValueNode valueNode) {
        this.valToGenerate = valueNode;
    }
}

